/*
 * Decompiled with CFR 0.152.
 */
package effectsizeplot.input.directeffectsize;

import effectsizeplot.input.directeffectsize.DirectESRow;
import formattazione.numeri.MyNumberFormatter;
import java.io.Serializable;

public class DirectESRowExtended
extends DirectESRow
implements Serializable {
    private Double standardError;
    private Double variance;
    private Double pValue;
    private Double weight;
    private Integer nASampleSize;

    public DirectESRowExtended() {
    }

    public DirectESRowExtended(Double effectSize, Double lowerLimit, Double upperLimit, Double pValue, Double variance, Double standardError, Double weight, String name, Integer sampleSize, Integer n1, Integer n2, Integer nASampleSize) {
        super(name, effectSize, lowerLimit, upperLimit, sampleSize, n1, n2);
        this.standardError = standardError;
        this.variance = variance;
        this.pValue = pValue;
        this.weight = weight;
        this.nASampleSize = nASampleSize;
    }

    public Double getStandardError() {
        return this.standardError;
    }

    public void setStandardError(Double standardError) {
        this.standardError = standardError;
    }

    public Double getVariance() {
        return this.variance;
    }

    public void setVariance(Double variance) {
        this.variance = variance;
    }

    public Double getPValue() {
        return this.pValue;
    }

    public void setPValue(Double pValue) {
        this.pValue = pValue;
    }

    public Double getWeight() {
        return this.weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public Integer getNASampleSize() {
        return this.nASampleSize;
    }

    public void setNASampleSize(Integer nASampleSize) {
        this.nASampleSize = nASampleSize;
    }

    public static DirectESRowExtended createFromText(String text, MyNumberFormatter myNumberFormatter) {
        DirectESRowExtended row = new DirectESRowExtended();
        String[] campi = text.split("\t");
        for (int i = 0; i < campi.length; ++i) {
            if (i == 0) {
                row.setName(campi[i]);
            }
            if (i == 1) {
                try {
                    row.setEffectSize(myNumberFormatter.getNumberFormat(14).parse(campi[i]).doubleValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i == 2) {
                try {
                    row.setLowerLimit(myNumberFormatter.getNumberFormat(14).parse(campi[i]).doubleValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i == 3) {
                try {
                    row.setUpperLimit(myNumberFormatter.getNumberFormat(14).parse(campi[i]).doubleValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i == 4) {
                try {
                    row.setPValue(myNumberFormatter.getNumberFormat(14).parse(campi[i]).doubleValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i == 5) {
                try {
                    row.setVariance(myNumberFormatter.getNumberFormat(14).parse(campi[i]).doubleValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i == 6) {
                try {
                    row.setStandardError(myNumberFormatter.getNumberFormat(14).parse(campi[i]).doubleValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i == 7) {
                try {
                    row.setSampleSize(myNumberFormatter.getNumberFormat(14).parse(campi[i]).intValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i == 8) {
                try {
                    row.setN1(myNumberFormatter.getNumberFormat(14).parse(campi[i]).intValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i == 9) {
                try {
                    row.setN2(myNumberFormatter.getNumberFormat(14).parse(campi[i]).intValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i != 10) continue;
            try {
                row.setNASampleSize(myNumberFormatter.getNumberFormat(14).parse(campi[i]).intValue());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return row;
    }

    @Override
    public String toText(MyNumberFormatter myNumberFormatter) {
        return this.getName() + "\t" + (this.getEffectSize() == null ? "" : myNumberFormatter.formatInLang(this.getEffectSize().doubleValue())) + "\t" + (this.getLowerLimit() == null ? "" : myNumberFormatter.formatInLang(this.getLowerLimit().doubleValue())) + "\t" + (this.getUpperLimit() == null ? "" : myNumberFormatter.formatInLang(this.getUpperLimit().doubleValue())) + "\t" + (this.getPValue() == null ? "" : myNumberFormatter.formatInLang(this.getPValue().doubleValue())) + "\t" + (this.getVariance() == null ? "" : myNumberFormatter.formatInLang(this.getVariance().doubleValue())) + "\t" + (this.getStandardError() == null ? "" : myNumberFormatter.formatInLang(this.getStandardError().doubleValue())) + "\t" + (this.getSampleSize() == null ? "" : myNumberFormatter.formatInLang(this.getSampleSize().intValue())) + "\t" + (this.getN1() == null ? "" : myNumberFormatter.formatInLang(this.getN1().intValue())) + "\t" + (this.getN2() == null ? "" : myNumberFormatter.formatInLang(this.getN2().intValue())) + "\t" + (this.nASampleSize == null ? "" : myNumberFormatter.formatInLang(this.nASampleSize.intValue()));
    }

    @Override
    public boolean isVoid() {
        return this.getName() == null && this.getEffectSize() == null && this.getLowerLimit() == null && this.getUpperLimit() == null && this.getPValue() == null && this.getVariance() == null && this.getStandardError() == null && this.getSampleSize() == null && this.getN1() == null && this.getN2() == null && this.nASampleSize == null;
    }
}

