/*
 * Decompiled with CFR 0.152.
 */
package effectsizeplot.input.directeffectsize;

import effectsizeplot.api.AEffectSizeEditorPanel;
import effectsizeplot.api.IEffectSizeSource;
import effectsizeplot.api.ITextImporterExporter;
import effectsizeplot.api.ImportExportTextException;
import effectsizeplot.input.directeffectsize.DirectESNewPanel;
import effectsizeplot.input.directeffectsize.DirectESRow;
import forestplot.api.BloccoDiRighe;
import forestplot.api.ColoumnDescripotrsFactory;
import forestplot.api.DataEntryRow;
import forestplot.api.FisherScale;
import forestplot.api.IScale;
import forestplot.api.LinearScale;
import forestplot.api.LogScale;
import forestplot.api.OverallRow;
import forestplot.api.PlotInputData;
import forestplot.api.ScaleDataInputErrorException;
import forestplot.api.VisualizerBean;
import formattazione.numeri.MyNumberFormatter;
import internovi.numbers.locale.provider.LocaleNumbersProvider;
import internovi.statisticaloptions.provider.StatisticalOptionProvider;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.openide.util.NbBundle;

public class DirectESSourceBean
implements ITextImporterExporter,
IEffectSizeSource,
Serializable {
    private IScale scale;
    public static int rowsNumber = 100;
    private VisualizerBean visualizerBean = new VisualizerBean();
    private String tipoDiScala = NbBundle.getMessage(DirectESSourceBean.class, (String)"scale.linear.name");
    private DirectESRow[] righe = new DirectESRow[rowsNumber];
    public static String esName = NbBundle.getMessage(DirectESSourceBean.class, (String)"directES.name");
    private double zeroValue;

    public DirectESSourceBean() {
        for (int i = 0; i < rowsNumber; ++i) {
            this.righe[i] = new DirectESRow();
        }
    }

    public VisualizerBean getVisualizerBean() {
        return this.visualizerBean;
    }

    public void setVisualizerBean(VisualizerBean visualizerBean) {
        this.visualizerBean = visualizerBean;
    }

    public String getTipoDiScala() {
        return this.tipoDiScala;
    }

    public void setTipoDiScala(String tipoDiScala) {
        this.tipoDiScala = tipoDiScala;
    }

    public DirectESRow[] getRighe() {
        return this.righe;
    }

    public void setRighe(DirectESRow[] righe) {
        this.righe = righe;
    }

    public DirectESRow getRighe(int index) {
        return this.righe[index];
    }

    public void setRighe(int index, DirectESRow newRighe) {
        this.righe[index] = newRighe;
    }

    public void writeToFile(OutputStream os) {
        XMLEncoder e = new XMLEncoder(new BufferedOutputStream(os));
        e.writeObject(this);
        e.close();
    }

    public void saveToStream(OutputStream os) {
        this.writeToFile(os);
    }

    public AEffectSizeEditorPanel getEditor() {
        return new DirectESNewPanel(this);
    }

    public PlotInputData getPlotInputData() throws ScaleDataInputErrorException {
        MyNumberFormatter myFormatter = new MyNumberFormatter(LocaleNumbersProvider.getLocale(), LocaleNumbersProvider.isGroupSeparatorDisplayed(), StatisticalOptionProvider.getRoundingMode());
        BloccoDiRighe blocco = new BloccoDiRighe();
        PlotInputData plotInputData = new PlotInputData();
        plotInputData.getBlocchiRighe().add((Object)blocco);
        plotInputData.setColonne(ColoumnDescripotrsFactory.generateEffectSizePlotterDescriptors((MyNumberFormatter)myFormatter));
        for (int i = 0; i < rowsNumber; ++i) {
            Object row = this.righe[i].getName() != null && !this.righe[i].getName().equals("") && this.righe[i].getName().substring(0, 1).equals("*") ? new OverallRow() : new DataEntryRow();
            if (this.righe[i].getEffectSize() == null || this.righe[i].getLowerLimit() == null || this.righe[i].getUpperLimit() == null) continue;
            try {
                if (row instanceof OverallRow) {
                    row.setName(this.righe[i].getName().substring(1));
                } else {
                    row.setName(this.righe[i].getName());
                }
                row.setEffectSize(this.righe[i].getEffectSize().doubleValue());
                row.setLowerLimit(this.righe[i].getLowerLimit());
                row.setUpperLimit(this.righe[i].getUpperLimit());
                blocco.add(row);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                row.setSampleSize(this.righe[i].getSampleSize().intValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                row.setN1(this.righe[i].getN1().intValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                row.setN2(this.righe[i].getN2().intValue());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        plotInputData.setZeroLineValue(this.zeroValue);
        this.scale = this.tipoDiScala.equals(NbBundle.getMessage(DirectESSourceBean.class, (String)"scale.fisher.name")) ? new FisherScale(plotInputData) : (this.tipoDiScala.equals(NbBundle.getMessage(DirectESSourceBean.class, (String)"scale.log.name")) ? new LogScale(plotInputData) : new LinearScale(plotInputData));
        plotInputData.setVisualizerBean(this.visualizerBean);
        plotInputData.setUp();
        return plotInputData;
    }

    public String getEffectSizeTypeName() {
        return esName;
    }

    public void importFromText(String text, boolean append) throws ImportExportTextException {
        MyNumberFormatter myFormatter = new MyNumberFormatter(LocaleNumbersProvider.getLocale(), LocaleNumbersProvider.isGroupSeparatorDisplayed(), StatisticalOptionProvider.getRoundingMode());
        String testo = "";
        if (append) {
            testo = this.exportToText();
        }
        if (!testo.equals("")) {
            testo = testo + "\n";
        }
        testo = testo + text;
        String[] arr = testo.split("\n");
        for (int r = 0; r < arr.length; ++r) {
            this.righe[r] = DirectESRow.createFromText(arr[r], myFormatter);
        }
        for (int k = arr.length; k < rowsNumber; ++k) {
            this.righe[k] = new DirectESRow();
        }
    }

    public String exportToText() throws ImportExportTextException {
        MyNumberFormatter myFormatter = new MyNumberFormatter(LocaleNumbersProvider.getLocale(), LocaleNumbersProvider.isGroupSeparatorDisplayed(), StatisticalOptionProvider.getRoundingMode());
        String ret = "";
        String aCapo = "";
        for (DirectESRow x : this.righe) {
            if (x.isVoid()) continue;
            ret = ret + aCapo + x.toText(myFormatter);
            aCapo = "\n";
        }
        return ret;
    }

    public IScale getScale() {
        return this.scale;
    }

    public double getZeroValue() {
        return this.zeroValue;
    }

    public void setZeroValue(double zeroValue) {
        this.zeroValue = zeroValue;
    }
}

