/*
 * Decompiled with CFR 0.152.
 */
package effectsizeplot.input.directeffectsize;

import effectsizeplot.api.AEffectSizeEditorPanel;
import effectsizeplot.api.IEffectSizeSource;
import effectsizeplot.api.ITextImporterExporter;
import effectsizeplot.api.ImportExportTextException;
import effectsizeplot.input.directeffectsize.DirectESExtendedPanel;
import effectsizeplot.input.directeffectsize.DirectESRowExtended;
import forestplot.api.AbstractForestPlotRow;
import forestplot.api.BloccoDiRighe;
import forestplot.api.ColoumnDescripotrsFactory;
import forestplot.api.DataEntryRow;
import forestplot.api.FisherScale;
import forestplot.api.IForestPlotRow;
import forestplot.api.IScale;
import forestplot.api.LinearScale;
import forestplot.api.LogScale;
import forestplot.api.OverallRow;
import forestplot.api.PlotInputData;
import forestplot.api.ScaleDataInputErrorException;
import forestplot.api.VisualizerBean;
import formattazione.numeri.MyNumberFormatter;
import internovi.numbers.locale.provider.LocaleNumbersProvider;
import internovi.statisticaloptions.provider.StatisticalOptionProvider;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.openide.util.NbBundle;

public class DirectESSourceBeanExtended
implements ITextImporterExporter,
IEffectSizeSource,
Serializable {
    private IScale scale;
    public static int rowsNumber = 100;
    private VisualizerBean visualizerBean = new VisualizerBean();
    private String tipoDiScala = NbBundle.getMessage(DirectESSourceBeanExtended.class, (String)"scale.linear.name");
    private DirectESRowExtended[] righe = new DirectESRowExtended[rowsNumber];
    public static String esName = NbBundle.getMessage(DirectESSourceBeanExtended.class, (String)"directESExtended.name");
    private double zeroValue;

    public DirectESSourceBeanExtended() {
        for (int i = 0; i < rowsNumber; ++i) {
            this.righe[i] = new DirectESRowExtended();
        }
    }

    public VisualizerBean getVisualizerBean() {
        return this.visualizerBean;
    }

    public void setVisualizerBean(VisualizerBean visualizerBean) {
        this.visualizerBean = visualizerBean;
    }

    public String getTipoDiScala() {
        return this.tipoDiScala;
    }

    public void setTipoDiScala(String tipoDiScala) {
        this.tipoDiScala = tipoDiScala;
    }

    public DirectESRowExtended[] getRighe() {
        return this.righe;
    }

    public void setRighe(DirectESRowExtended[] righe) {
        this.righe = righe;
    }

    public DirectESRowExtended getRighe(int index) {
        return this.righe[index];
    }

    public void setRighe(int index, DirectESRowExtended newRighe) {
        this.righe[index] = newRighe;
    }

    public void writeToFile(OutputStream os) {
        XMLEncoder e = new XMLEncoder(new BufferedOutputStream(os));
        e.writeObject(this);
        e.close();
    }

    public void saveToStream(OutputStream os) {
        this.writeToFile(os);
    }

    public AEffectSizeEditorPanel getEditor() {
        return new DirectESExtendedPanel(this);
    }

    public PlotInputData getPlotInputData() throws ScaleDataInputErrorException {
        MyNumberFormatter myFormatter = new MyNumberFormatter(LocaleNumbersProvider.getLocale(), LocaleNumbersProvider.isGroupSeparatorDisplayed(), StatisticalOptionProvider.getRoundingMode());
        BloccoDiRighe blocco = new BloccoDiRighe();
        PlotInputData plotInputData = new PlotInputData();
        plotInputData.getBlocchiRighe().add((Object)blocco);
        plotInputData.setColonne(ColoumnDescripotrsFactory.generateStandardMetaAnalisyDescriptors((MyNumberFormatter)myFormatter));
        for (int i = 0; i < rowsNumber; ++i) {
            AbstractForestPlotRow fromDirectESRowExtendedToAbstractForestPlotRow = DirectESSourceBeanExtended.fromDirectESRowExtendedToAbstractForestPlotRow(this.righe[i]);
            if (fromDirectESRowExtendedToAbstractForestPlotRow == null) continue;
            blocco.add((Object)fromDirectESRowExtendedToAbstractForestPlotRow);
        }
        plotInputData.setZeroLineValue(this.zeroValue);
        this.scale = this.tipoDiScala.equals(NbBundle.getMessage(DirectESSourceBeanExtended.class, (String)"scale.fisher.name")) ? new FisherScale(plotInputData) : (this.tipoDiScala.equals(NbBundle.getMessage(DirectESSourceBeanExtended.class, (String)"scale.log.name")) ? new LogScale(plotInputData) : new LinearScale(plotInputData));
        plotInputData.setVisualizerBean(this.visualizerBean);
        plotInputData.setUp();
        return plotInputData;
    }

    public String getEffectSizeTypeName() {
        return esName;
    }

    public void importFromText(String text, boolean append) throws ImportExportTextException {
        MyNumberFormatter myFormatter = new MyNumberFormatter(LocaleNumbersProvider.getLocale(), LocaleNumbersProvider.isGroupSeparatorDisplayed(), StatisticalOptionProvider.getRoundingMode());
        String testo = "";
        if (append) {
            testo = this.exportToText();
        }
        if (!testo.equals("")) {
            testo = testo + "\n";
        }
        testo = testo + text;
        String[] arr = testo.split("\n");
        for (int r = 0; r < arr.length; ++r) {
            this.righe[r] = DirectESRowExtended.createFromText(arr[r], myFormatter);
        }
        for (int k = arr.length; k < rowsNumber; ++k) {
            this.righe[k] = new DirectESRowExtended();
        }
    }

    public String exportToText() throws ImportExportTextException {
        MyNumberFormatter myFormatter = new MyNumberFormatter(LocaleNumbersProvider.getLocale(), LocaleNumbersProvider.isGroupSeparatorDisplayed(), StatisticalOptionProvider.getRoundingMode());
        String ret = "";
        String aCapo = "";
        for (DirectESRowExtended x : this.righe) {
            if (x.isVoid()) continue;
            ret = ret + aCapo + x.toText(myFormatter);
            aCapo = "\n";
        }
        return ret;
    }

    public IScale getScale() {
        return this.scale;
    }

    public double getZeroValue() {
        return this.zeroValue;
    }

    public void setZeroValue(double zeroValue) {
        this.zeroValue = zeroValue;
    }

    public static AbstractForestPlotRow fromDirectESRowExtendedToAbstractForestPlotRow(DirectESRowExtended input) {
        Object row = input.getName() != null && !input.getName().equals("") && input.getName().substring(0, 1).equals("*") ? new OverallRow() : new DataEntryRow();
        if (input.getEffectSize() != null && input.getLowerLimit() != null && input.getUpperLimit() != null) {
            try {
                if (row instanceof OverallRow) {
                    row.setName(input.getName().substring(1));
                } else {
                    row.setName(input.getName());
                }
                row.setEffectSize(input.getEffectSize().doubleValue());
                row.setLowerLimit(input.getLowerLimit());
                row.setUpperLimit(input.getUpperLimit());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                row.setSampleSize(input.getSampleSize().intValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                row.setN1(input.getN1().intValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                row.setN2(input.getN2().intValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                row.setNotAssignedSampleSize(input.getNASampleSize().intValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                row.setPValue(input.getPValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                row.setVariance(input.getVariance());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                row.setStandardError(input.getStandardError());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                row.setWeight(input.getWeight().doubleValue());
            }
            catch (Exception exception) {}
        } else {
            return null;
        }
        return row;
    }

    public static DirectESRowExtended fromIForestPlotRowToDirectESRowExtended(IForestPlotRow r) {
        DirectESRowExtended directESRowExtended = new DirectESRowExtended();
        if (r instanceof OverallRow) {
            directESRowExtended.setName("*" + r.getName());
        } else {
            directESRowExtended.setName(r.getName());
        }
        directESRowExtended.setEffectSize(r.getEffectSize());
        directESRowExtended.setUpperLimit(r.getUpperLimit());
        directESRowExtended.setLowerLimit(r.getLowerLimit());
        directESRowExtended.setPValue(r.getPValue());
        directESRowExtended.setVariance(r.getVariance());
        directESRowExtended.setStandardError(r.getStandardError());
        directESRowExtended.setWeight(r.getWeight());
        directESRowExtended.setSampleSize(r.getSampleSize());
        directESRowExtended.setN1(r.getN1());
        directESRowExtended.setN2(r.getN2());
        directESRowExtended.setNASampleSize(r.getNotAssignedSampleSize());
        return directESRowExtended;
    }
}

