/*
 * Decompiled with CFR 0.152.
 */
package info.dmtree.security;

import info.dmtree.security.DmtPrincipalPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;

final class DmtPrincipalPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = -6692103535775802684L;
    private ArrayList perms = new ArrayList();

    public void add(Permission permission) {
        if (!(permission instanceof DmtPrincipalPermission)) {
            throw new IllegalArgumentException("Cannot add permission, invalid permission type: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("Cannot add permission, collection is marked read-only.");
        }
        if (!this.implies(permission)) {
            Iterator i = this.perms.iterator();
            while (i.hasNext()) {
                if (!permission.implies((DmtPrincipalPermission)i.next())) continue;
                i.remove();
            }
            this.perms.add(permission);
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof DmtPrincipalPermission)) {
            return false;
        }
        DmtPrincipalPermission other = (DmtPrincipalPermission)permission;
        Iterator i = this.perms.iterator();
        while (i.hasNext()) {
            if (!((DmtPrincipalPermission)i.next()).impliesPrincipal(other)) continue;
            return true;
        }
        return false;
    }

    public Enumeration elements() {
        return Collections.enumeration(this.perms);
    }
}

