/*
 * Decompiled with CFR 0.152.
 */
package metaanalyisis.guiandnodes.moderators;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import metaanalyisis.guiandnodes.moderators.editors.LittleGuiFunctions;
import metaanalyisis.guiandnodes.moderators.editors.ModeratorReportGenerator;
import metaanalyisis.guiandnodes.moderators.events.ModeratorrecodeRoleAddedEvent;
import metaanalyisis.guiandnodes.moderators.events.ModeratorrecodeRoleDragAwayEvent;
import metaanalyisis.guiandnodes.moderators.events.ModeratorrecodeRoleUpdatedEvent;
import metaanalysis.core.flavors.ModeratorrecodeSourceValueNodeFlavor;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ModeratorrecodeEvents;
import metaanalysis.core.persistence.Moderatorrecode;
import metaanalysis.dataeditor.models.AbstractApplicationNode;
import metaanalysis.events.models.IApplicationEvent;
import metaanalysis.moderatorrecode.apis.IRecodeRole;
import metaanalysis.moderatorrecode.apis.ModeratorRecodeMachine;
import metaanalysis.moderatorrecode.apis.StringRole;
import org.openide.nodes.Children;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

public class CategoricalModeratorrecodeSourceValuesContainerNode
extends AbstractApplicationNode
implements PropertyChangeListener {
    private final Moderatorrecode moderatorrecode;
    private final StringRole role;
    private final ModeratorRecodeMachine moderatorRecodeMachine;
    private ModeratorReportGenerator reportGenerator;

    public CategoricalModeratorrecodeSourceValuesContainerNode(Moderatorrecode moderatorrecode, ModeratorRecodeMachine moderatorRecodeMachine, StringRole role, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children, Lookups.singleton((Object)moderatorrecode));
        this.moderatorrecode = moderatorrecode;
        this.moderatorRecodeMachine = moderatorRecodeMachine;
        this.role = role;
        this.reportGenerator = new ModeratorReportGenerator(applicationEventWorker.getIDataFunction().getModerator(moderatorrecode.getModeratorId().intValue()), applicationEventWorker);
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
        this.setAllVeryWell();
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/triangle_iconClose.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/triangle_iconOpen.png");
    }

    public boolean canDestroy() {
        return false;
    }

    public void destroy() {
    }

    public PasteType getDropType(final Transferable t, int arg1, int arg2) {
        if (t.isDataFlavorSupported(ModeratorrecodeSourceValueNodeFlavor.ModeratorrecodeSourceValueNode_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        ArrayList<String> lista;
                        String value = (String)t.getTransferData(ModeratorrecodeSourceValueNodeFlavor.ModeratorrecodeSourceValueNode_FLAVOR);
                        IRecodeRole regolaPrecedente = CategoricalModeratorrecodeSourceValuesContainerNode.this.moderatorRecodeMachine.match(value);
                        if (regolaPrecedente != null) {
                            lista = new ArrayList<String>();
                            lista.addAll(Arrays.asList(((StringRole)regolaPrecedente).getMatchedValue()));
                            lista.remove(value);
                            ((StringRole)regolaPrecedente).setMatchedValue(lista.toArray(new String[0]));
                            CategoricalModeratorrecodeSourceValuesContainerNode.this.applicationEventWorker.setApplicationEvent((IApplicationEvent)new ModeratorrecodeRoleDragAwayEvent(CategoricalModeratorrecodeSourceValuesContainerNode.this.moderatorrecode, regolaPrecedente));
                        }
                        lista = new ArrayList();
                        lista.addAll(Arrays.asList(CategoricalModeratorrecodeSourceValuesContainerNode.this.role.getMatchedValue()));
                        lista.add(value);
                        CategoricalModeratorrecodeSourceValuesContainerNode.this.role.setMatchedValue(lista.toArray(new String[0]));
                        CategoricalModeratorrecodeSourceValuesContainerNode.this.applicationEventWorker.setApplicationEvent((IApplicationEvent)new ModeratorrecodeRoleUpdatedEvent(CategoricalModeratorrecodeSourceValuesContainerNode.this.moderatorrecode, (IRecodeRole)CategoricalModeratorrecodeSourceValuesContainerNode.this.role));
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    CategoricalModeratorrecodeSourceValuesContainerNode.this.setAllVeryWell();
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        super.createPasteTypes(t, s);
        PasteType p = this.getDropType(t, 0, 0);
        if (p != null) {
            s.add(p);
        }
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new ChangeRoleCodedValueAction(), null, new RemoveRoleAction()};
    }

    public final void setAllVeryWell() {
        this.setName(this.role.getCodedValue() + " (" + this.reportGenerator.getCategoricalModeratorValuesFrequence(this.role.getMatchedValue()) + "/" + this.reportGenerator.getModeratorsValueAmount() + ")");
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent") && pce.getNewValue() instanceof ModeratorrecodeEvents && pce.getNewValue() instanceof ModeratorrecodeRoleDragAwayEvent && ((ModeratorrecodeRoleDragAwayEvent)pce.getNewValue()).getRole() == this.role) {
            this.setAllVeryWell();
        }
    }

    private class ChangeRoleCodedValueAction
    extends AbstractAction {
        public ChangeRoleCodedValueAction() {
            this.putValue("Name", NbBundle.getMessage(ChangeRoleCodedValueAction.class, (String)"ChangeRoleCodedValueAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String createNewRolePopUpGui = LittleGuiFunctions.createNewRolePopUpGui();
            if (createNewRolePopUpGui != null && !createNewRolePopUpGui.equals("")) {
                CategoricalModeratorrecodeSourceValuesContainerNode.this.role.setCodedValue(createNewRolePopUpGui);
                CategoricalModeratorrecodeSourceValuesContainerNode.this.setName(CategoricalModeratorrecodeSourceValuesContainerNode.this.role.getCodedValue());
            }
        }
    }

    private class RemoveRoleAction
    extends AbstractAction
    implements Presenter.Popup {
        public RemoveRoleAction() {
            this.putValue("Name", NbBundle.getMessage(RemoveRoleAction.class, (String)"RemoveRoleAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CategoricalModeratorrecodeSourceValuesContainerNode.this.moderatorRecodeMachine.getRoles().remove(CategoricalModeratorrecodeSourceValuesContainerNode.this.role);
            CategoricalModeratorrecodeSourceValuesContainerNode.this.applicationEventWorker.setApplicationEvent((IApplicationEvent)new ModeratorrecodeRoleAddedEvent(CategoricalModeratorrecodeSourceValuesContainerNode.this.moderatorrecode, (IRecodeRole)CategoricalModeratorrecodeSourceValuesContainerNode.this.role));
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/delete_icon.png")));
            return x;
        }
    }
}

