/*
 * Decompiled with CFR 0.152.
 */
package metaanalyisis.guiandnodes.moderators;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalyisis.guiandnodes.moderators.editors.CategoricalModeratorEditorPanel;
import metaanalyisis.guiandnodes.moderators.editors.ModeratorEditorPanel;
import metaanalysis.actions.models.DefineModeratorrecodeAA;
import metaanalysis.actions.models.RemoveModeratorAA;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.flavors.ModeratorFlavor;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ModeratorEvents;
import metaanalysis.core.functionsapi.events.ModeratorUpdatedEvent;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.dataeditor.models.AbstractApplicationNode;
import metaanalysis.dataeditor.models.AbstractEditorPanel;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;

public class ModeratorNode
extends AbstractApplicationNode
implements PropertyChangeListener {
    private final Moderator moderator;

    public ModeratorNode(Moderator moderator, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children, Lookups.singleton((Object)moderator));
        this.moderator = moderator;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/moderator_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/moderator_iconOpen.png");
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canDestroy() {
        return this.moderator.getSystemlevel().equals(Moderator.standardSystemLevel);
    }

    public void destroy() {
        this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveModeratorAA(this.moderator, this.applicationEventWorker));
    }

    public Transferable clipboardCut() throws IOException {
        Transferable deflt = super.clipboardCut();
        ExTransferable added = ExTransferable.create((Transferable)deflt);
        added.put(new ExTransferable.Single(ModeratorFlavor.MODERATOR_FLAVOR){

            protected Moderator getData() {
                return (Moderator)ModeratorNode.this.getLookup().lookup(Moderator.class);
            }
        });
        return added;
    }

    public Transferable clipboardCopy() throws IOException {
        Transferable deflt = super.clipboardCopy();
        ExTransferable added = ExTransferable.create((Transferable)deflt);
        added.put(new ExTransferable.Single(ModeratorFlavor.MODERATOR_FLAVOR){

            protected Moderator getData() {
                return (Moderator)ModeratorNode.this.getLookup().lookup(Moderator.class);
            }
        });
        return added;
    }

    public String getDisplayName() {
        return ((Moderator)this.getLookup().lookup(Moderator.class)).getName();
    }

    public Action[] getActions(boolean context) {
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        arrayList.add(new AddModeratorrecodeAction());
        if (this.canDestroy()) {
            arrayList.add(new DeleteModeratorAction());
        }
        return arrayList.toArray(new Action[0]);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent") && pce.getNewValue() instanceof ModeratorEvents && ((ModeratorEvents)pce.getNewValue()).getModerator().getId() == this.moderator.getId() && pce.getNewValue() instanceof ModeratorUpdatedEvent) {
            ModeratorUpdatedEvent tmp = (ModeratorUpdatedEvent)pce.getNewValue();
            this.moderator.copyFrom(tmp.getModerator());
            this.setName(this.moderator.getName());
            this.setDisplayName(this.moderator.getName());
        }
    }

    public AbstractEditorPanel getNodeEditor() {
        if (this.moderator.getModeratortype() == Moderator.categoricalType) {
            return new CategoricalModeratorEditorPanel(this.moderator.getId(), this.applicationEventWorker, new GuiChecker(this.applicationEventWorker.getEditorPanelsUndoRedoManager(), TuliTuliTools.isAutoSelectContentFieldEnabled()));
        }
        return new ModeratorEditorPanel(this.moderator.getId(), this.applicationEventWorker, new GuiChecker(this.applicationEventWorker.getEditorPanelsUndoRedoManager(), TuliTuliTools.isAutoSelectContentFieldEnabled()));
    }

    private class DeleteModeratorAction
    extends AbstractAction
    implements Presenter.Popup {
        public DeleteModeratorAction() {
            this.putValue("Name", NbBundle.getMessage(AddModeratorrecodeAction.class, (String)"ModeratorNode.RemoveAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModeratorNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveModeratorAA(ModeratorNode.this.moderator, ModeratorNode.this.applicationEventWorker));
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/delete_icon.png")));
            return x;
        }
    }

    private class AddModeratorrecodeAction
    extends AbstractAction
    implements Presenter.Popup {
        public AddModeratorrecodeAction() {
            this.putValue("Name", NbBundle.getMessage(AddModeratorrecodeAction.class, (String)"ModeratorNode.AddModeratorrecodeAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String nome = JOptionPane.showInputDialog(null, NbBundle.getMessage(AddModeratorrecodeAction.class, (String)"AddModeratorrecodeAction.newModeratorrecodeName"), NbBundle.getMessage(AddModeratorrecodeAction.class, (String)"AddModeratorrecodeAction.barTitle"), 1);
            if (nome != null) {
                ModeratorNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineModeratorrecodeAA(nome, ModeratorNode.this.moderator, ModeratorNode.this.applicationEventWorker));
            }
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/create_icon.png")));
            return x;
        }
    }
}

