/*
 * Decompiled with CFR 0.152.
 */
package metaanalyisis.guiandnodes.moderators;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalyisis.guiandnodes.moderators.editors.AModeratorvalueEditor;
import metaanalyisis.guiandnodes.moderators.editors.CategoricalModeratorValueEditorPanel;
import metaanalyisis.guiandnodes.moderators.editors.ContinuousModeratorValueEditorPanel;
import metaanalyisis.guiandnodes.moderators.editors.IntegerModeratorValueEditorPanel;
import metaanalysis.actions.models.ResetModeratorValueAA;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.flavors.ModeratorvalueFlavor;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ModeratorEvents;
import metaanalysis.core.functionsapi.events.ModeratorUpdatedEvent;
import metaanalysis.core.functionsapi.events.ModeratorValueEvents;
import metaanalysis.core.functionsapi.events.ModeratorValueUpdatedEvent;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.dataeditor.models.AbstractApplicationNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;

public class ModeratorValueNode
extends AbstractApplicationNode
implements PropertyChangeListener {
    private Moderator moderator;
    private Moderatorvalue moderatorvalue;

    public ModeratorValueNode(Moderatorvalue moderatorvalue, Moderator moderator, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children, Lookups.singleton((Object)moderatorvalue));
        this.moderator = moderator;
        this.moderatorvalue = moderatorvalue;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
        this.setDisplayName(this.moderator.getName());
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/moderator_value_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/moderator_value_iconOpen.png");
    }

    public boolean canCut() {
        return false;
    }

    public boolean canCopy() {
        return this.moderator.getSystemlevel().equals(Moderator.standardSystemLevel);
    }

    public boolean canDestroy() {
        return false;
    }

    public void destroy() {
    }

    public Transferable clipboardCut() throws IOException {
        Transferable deflt = super.clipboardCut();
        ExTransferable added = ExTransferable.create((Transferable)deflt);
        added.put(new ExTransferable.Single(ModeratorvalueFlavor.MODERATORVALUE_FLAVOR){

            protected Moderatorvalue getData() {
                return (Moderatorvalue)ModeratorValueNode.this.getLookup().lookup(Moderatorvalue.class);
            }
        });
        return added;
    }

    public Transferable clipboardCopy() throws IOException {
        Transferable deflt = super.clipboardCopy();
        ExTransferable added = ExTransferable.create((Transferable)deflt);
        added.put(new ExTransferable.Single(ModeratorvalueFlavor.MODERATORVALUE_FLAVOR){

            protected Moderatorvalue getData() {
                return (Moderatorvalue)ModeratorValueNode.this.getLookup().lookup(Moderatorvalue.class);
            }
        });
        return added;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent")) {
            ModeratorValueUpdatedEvent tmp;
            if (pce.getNewValue() instanceof ModeratorValueEvents && ((ModeratorValueEvents)pce.getNewValue()).getModeratorValue().getId().equals((Object)this.moderatorvalue.getId()) && pce.getNewValue() instanceof ModeratorValueUpdatedEvent) {
                tmp = (ModeratorValueUpdatedEvent)pce.getNewValue();
                this.moderatorvalue.copyFrom(tmp.getModeratorValue());
            }
            if (pce.getNewValue() instanceof ModeratorEvents && ((ModeratorEvents)pce.getNewValue()).getModerator().getId() == this.moderator.getId() && pce.getNewValue() instanceof ModeratorUpdatedEvent) {
                tmp = (ModeratorUpdatedEvent)pce.getNewValue();
                this.moderator.copyFrom(tmp.getModerator());
                this.setName(this.moderator.getName());
                this.setDisplayName(this.moderator.getName());
            }
        }
    }

    public Action[] getActions(boolean popup) {
        ArrayList<ResetModeratorvalueAction> actions = new ArrayList<ResetModeratorvalueAction>();
        actions.add(new ResetModeratorvalueAction());
        return actions.toArray(new Action[actions.size()]);
    }

    public AModeratorvalueEditor getNodeEditor() {
        if (this.moderatorvalue.getModeratortype() == Moderator.categoricalType) {
            return new CategoricalModeratorValueEditorPanel(this.moderatorvalue.getId().duplicate(), this.moderator.getId(), this.applicationEventWorker, new GuiChecker(this.applicationEventWorker.getEditorPanelsUndoRedoManager(), TuliTuliTools.isAutoSelectContentFieldEnabled()));
        }
        if (this.moderatorvalue.getModeratortype() == Moderator.continuousType) {
            return new ContinuousModeratorValueEditorPanel(this.moderatorvalue.getId().duplicate(), this.moderator.getId(), this.applicationEventWorker, new GuiChecker(this.applicationEventWorker.getEditorPanelsUndoRedoManager(), TuliTuliTools.isAutoSelectContentFieldEnabled()));
        }
        return new IntegerModeratorValueEditorPanel(this.moderatorvalue.getId().duplicate(), this.moderator.getId(), this.applicationEventWorker, new GuiChecker(this.applicationEventWorker.getEditorPanelsUndoRedoManager(), TuliTuliTools.isAutoSelectContentFieldEnabled()));
    }

    private class ResetModeratorvalueAction
    extends AbstractAction
    implements Presenter.Popup {
        public ResetModeratorvalueAction() {
            this.putValue("Name", NbBundle.getMessage(ResetModeratorvalueAction.class, (String)"ModeratorValueNode.ResetModeratorvalueAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModeratorValueNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new ResetModeratorValueAA(ModeratorValueNode.this.moderatorvalue, ModeratorValueNode.this.applicationEventWorker));
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/reset_icon.png")));
            return x;
        }
    }
}

