/*
 * Decompiled with CFR 0.152.
 */
package metaanalyisis.guiandnodes.moderators;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import metaanalysis.actions.models.DefineModeratorAA;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Topic;
import metaanalysis.dataeditor.models.AbstractContainerNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class ModeratorsContainerNode
extends AbstractContainerNode {
    private final Topic topic;

    public ModeratorsContainerNode(Topic topic, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children);
        this.topic = topic;
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/moderator_folder_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/moderator_folder_iconOpen.png");
    }

    public Action[] getActions(boolean popup) {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        actions.add(new AddCategoricalModeratorAction());
        actions.add(new AddCountinuousModeratorAction());
        actions.add(new AddIntegerModeratorAction());
        return actions.toArray(new Action[actions.size()]);
    }

    public String getHtmlDisplayName() {
        return NbBundle.getMessage(ModeratorsContainerNode.class, (String)"ModeratorsContainerNode.displayName");
    }

    private class AddCategoricalModeratorAction
    extends AbstractAction
    implements Presenter.Popup {
        public AddCategoricalModeratorAction() {
            this.putValue("Name", NbBundle.getMessage(AddCategoricalModeratorAction.class, (String)"ModeratorsContainerNode.AddCategoricalModeratorAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String nome = JOptionPane.showInputDialog(null, NbBundle.getMessage(AddCategoricalModeratorAction.class, (String)"AddModeratorAction.newModeratorName"), NbBundle.getMessage(AddCategoricalModeratorAction.class, (String)"AddModeratorAction.insertNewModeratorBarTitle"), 1);
            if (nome != null) {
                ModeratorsContainerNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineModeratorAA(nome, ModeratorsContainerNode.this.topic, ModeratorsContainerNode.this.applicationEventWorker, Moderator.categoricalType, Moderator.standardSystemLevel));
            }
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/create_icon.png")));
            return x;
        }
    }

    private class AddCountinuousModeratorAction
    extends AbstractAction
    implements Presenter.Popup {
        public AddCountinuousModeratorAction() {
            this.putValue("Name", NbBundle.getMessage(AddCountinuousModeratorAction.class, (String)"ModeratorsContainerNode.AddCountinuousModeratorAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String nome = JOptionPane.showInputDialog(null, NbBundle.getMessage(AddCountinuousModeratorAction.class, (String)"AddModeratorAction.newModeratorName"), NbBundle.getMessage(AddCountinuousModeratorAction.class, (String)"AddModeratorAction.insertNewModeratorBarTitle"), 1);
            if (nome != null) {
                ModeratorsContainerNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineModeratorAA(nome, ModeratorsContainerNode.this.topic, ModeratorsContainerNode.this.applicationEventWorker, Moderator.continuousType, Moderator.standardSystemLevel));
            }
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/create_icon.png")));
            return x;
        }
    }

    private class AddIntegerModeratorAction
    extends AbstractAction
    implements Presenter.Popup {
        public AddIntegerModeratorAction() {
            this.putValue("Name", NbBundle.getMessage(AddIntegerModeratorAction.class, (String)"ModeratorsContainerNode.AddIntegerModeratorAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String nome = JOptionPane.showInputDialog(null, NbBundle.getMessage(AddIntegerModeratorAction.class, (String)"AddModeratorAction.newModeratorName"), NbBundle.getMessage(AddIntegerModeratorAction.class, (String)"AddModeratorAction.insertNewModeratorBarTitle"), 1);
            if (nome != null) {
                ModeratorsContainerNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineModeratorAA(nome, ModeratorsContainerNode.this.topic, ModeratorsContainerNode.this.applicationEventWorker, Moderator.integerType, Moderator.standardSystemLevel));
            }
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/create_icon.png")));
            return x;
        }
    }
}

