/*
 * Decompiled with CFR 0.152.
 */
package metaanalyisis.guiandnodes.moderators.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import metaanalsysis.guiutil.guicheckers.AbstractRole;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalsysis.guiutil.guicheckers.StringNotNullRole;
import metaanalyisis.guiandnodes.moderators.editors.CategoricalModeratorEditorPanelTop;
import metaanalyisis.guiandnodes.moderators.editors.DefaultValueLabel;
import metaanalyisis.guiandnodes.moderators.tables.ModeratorStatisticBuilder;
import metaanalyisis.guiandnodes.moderators.tables.TableModeratorReport;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ModeratorEvents;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.dataeditor.models.AbstractEditorPanel;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.NbBundle;

public class CategoricalModeratorEditorPanel
extends AbstractEditorPanel
implements PropertyChangeListener {
    private Moderator moderator;
    private CategoricalModeratorEditorPanelTop topPanel;
    private final int moderatorId;

    public CategoricalModeratorEditorPanel(int moderatorId, IApplicationManager applicationEventWorker, GuiChecker guiChecker) {
        super(applicationEventWorker, guiChecker);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.moderatorId = moderatorId;
        this.reloadAll();
    }

    public final void reloadAll() {
        this.moderator = this.applicationEventWorker.getIDataFunction().getModerator(this.moderatorId);
        if (this.moderator == null) {
            this.scompari();
        } else {
            this.removeAll();
            this.topPanel = new CategoricalModeratorEditorPanelTop(this.moderator, this.getGuiChecker(), this.applicationEventWorker);
            String qwerty = this.moderator.getDefvalues();
            String[] defvalues = new String[]{};
            if (qwerty != null) {
                defvalues = qwerty.split("\n");
            }
            JPanel xxx = new JPanel();
            xxx.setBackground(StyleProvider.panelBackground);
            xxx.setSize(400, 10 + 35 * defvalues.length);
            xxx.setLayout(new BoxLayout(xxx, 3));
            for (String tmp : defvalues) {
                if (tmp.equals("")) continue;
                xxx.add(new DefaultValueLabel(this.moderator, this.getIApplicationManager(), tmp));
            }
            this.topPanel.scrollContainerJPanel.removeAll();
            this.topPanel.scrollContainerJPanel.add(new JScrollPane(xxx));
            this.topPanel.validate();
            this.topPanel.setAlignmentX(0.0f);
            this.add((Component)((Object)this.topPanel));
            this.guiChecker.svuota();
            this.guiChecker.addRole((AbstractRole)new StringNotNullRole(this.topPanel.nameValue, this.moderator.getName()));
            this.guiChecker.getEligibleObjects().add(this.topPanel.saveButton);
            JPanel xx = new JPanel();
            xx.setLayout(new BorderLayout());
            ModeratorStatisticBuilder msb = new ModeratorStatisticBuilder(this.moderator, this.applicationEventWorker);
            TableModeratorReport table = msb.build();
            xx.setAlignmentX(0.0f);
            table.getRowCount();
            xx.setSize(635, table.getRowsHeigt());
            xx.setMaximumSize(new Dimension(635, table.getRowsHeigt()));
            xx.add((Component)table.getTableHeader(), "North");
            xx.add((Component)((Object)table), "Center");
            this.add(xx);
            JPanel footer = new JPanel();
            footer.setBackground(StyleProvider.panelBackground);
            this.add(footer);
        }
        this.validate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent")) {
            // empty if block
        }
    }

    public boolean readApplicationEvent(IApplicationEvent event) {
        if (event instanceof ModeratorEvents && ((ModeratorEvents)event).getModerator().getId() == this.moderatorId) {
            this.reloadAll();
            return true;
        }
        return false;
    }

    public String getBarTitle() {
        return NbBundle.getMessage(CategoricalModeratorEditorPanel.class, (String)"ModeratorEditorPanel.barTitle");
    }
}

