/*
 * Decompiled with CFR 0.152.
 */
package metaanalyisis.guiandnodes.moderators.editors;

import formattazione.numeri.MyNumberFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import metaanalyisis.guiandnodes.moderators.editors.ModeratorEditorPanel;
import metaanalyisis.guiandnodes.moderators.functions.ModeratorsAdvancedFunctions;
import metaanalysis.core.functionsapi.DatabaseTreeNullException;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorvalue;
import org.openide.util.NbBundle;

public class ModeratorReportGenerator {
    protected MyNumberFormatter myNumberFormatter;
    protected Moderator moderator;
    protected IApplicationManager applicationEventWorker;

    public ModeratorReportGenerator(Moderator moderator, IApplicationManager applicationEventWorker) {
        this.moderator = moderator;
        this.applicationEventWorker = applicationEventWorker;
        this.myNumberFormatter = applicationEventWorker.getMyNumberFormatter();
    }

    public int getModeratorsValueAmount() {
        return this.applicationEventWorker.getIDataFunction().getAllModeratorValuesOfModerator(this.moderator).size();
    }

    public int getCategoricalModeratorValueFrequence(String value) {
        List allModeratorValuesOfModerator = this.applicationEventWorker.getIDataFunction().getAllModeratorValuesOfModerator(this.moderator);
        int volte = 0;
        if (value != null) {
            for (Moderatorvalue mv : allModeratorValuesOfModerator) {
                if (mv.getCategoricalvalue() == null || !mv.getCategoricalvalue().equals(value)) continue;
                ++volte;
            }
        } else {
            for (Moderatorvalue mv : allModeratorValuesOfModerator) {
                if (mv.getCategoricalvalue() != null) continue;
                ++volte;
            }
        }
        return volte;
    }

    public String getCategoricalModeratorValueStudiesNames(String value) throws DatabaseTreeNullException {
        List allModeratorValuesOfModerator = this.applicationEventWorker.getIDataFunction().getAllModeratorValuesOfModerator(this.moderator);
        if (value == null) {
            return "";
        }
        String ret = "<html>";
        String pre = "";
        for (Moderatorvalue mv : allModeratorValuesOfModerator) {
            if (mv.getCategoricalvalue() == null || !mv.getCategoricalvalue().equals(value)) continue;
            ret = ret + pre + ModeratorsAdvancedFunctions.getCompleteNameOfModeratorValue(mv, this.applicationEventWorker);
            pre = "<br/>";
        }
        return ret + "</html>";
    }

    public int getCategoricalModeratorValuesFrequence(String[] values) {
        int volte = 0;
        for (String v : values) {
            volte += this.getCategoricalModeratorValueFrequence(v);
        }
        return volte;
    }

    public int getIntegerModeratorValueFrequence(Integer value) {
        List allModeratorValuesOfModerator = this.applicationEventWorker.getIDataFunction().getAllModeratorValuesOfModerator(this.moderator);
        int volte = 0;
        if (value != null) {
            for (Moderatorvalue mv : allModeratorValuesOfModerator) {
                if (mv.getIntegervalue() == null || mv.getIntegervalue().compareTo(value) != 0) continue;
                ++volte;
            }
        } else {
            for (Moderatorvalue mv : allModeratorValuesOfModerator) {
                if (mv.getCategoricalvalue() != null) continue;
                ++volte;
            }
        }
        return volte;
    }

    public String shortUsedValuesReport() {
        int volte;
        ArrayList<Object> valori;
        String report = "Moderator values and frequencies\n\n";
        List allModeratorValuesOfModerator = this.applicationEventWorker.getIDataFunction().getAllModeratorValuesOfModerator(this.moderator);
        int size = allModeratorValuesOfModerator.size();
        ArrayList<String> missingLocations = new ArrayList<String>();
        int nullSize = 0;
        for (Object mv : allModeratorValuesOfModerator) {
            if (!mv.isNull()) continue;
            try {
                missingLocations.add(ModeratorsAdvancedFunctions.getCompleteNameOfModeratorValue((Moderatorvalue)mv, this.applicationEventWorker));
            }
            catch (DatabaseTreeNullException ex) {
                missingLocations.add("Error on Moderator " + mv.getId());
            }
        }
        if (this.moderator.getModeratortype() == Moderator.categoricalType) {
            valori = new ArrayList<Object>();
            for (Moderatorvalue mv : allModeratorValuesOfModerator) {
                if (mv.getCategoricalvalue() == null) {
                    ++nullSize;
                    continue;
                }
                if (valori.contains(mv.getCategoricalvalue())) continue;
                valori.add(mv.getCategoricalvalue());
            }
            Collections.sort(valori);
            for (Object v : valori) {
                volte = 0;
                for (Moderatorvalue mv : allModeratorValuesOfModerator) {
                    if (mv.getCategoricalvalue() == null || !mv.getCategoricalvalue().equals(v)) continue;
                    ++volte;
                }
                report = report + (String)v + " (" + volte + "/" + size + ")\n";
            }
        } else if (this.moderator.getModeratortype() == Moderator.integerType) {
            valori = new ArrayList();
            for (Moderatorvalue mv : allModeratorValuesOfModerator) {
                if (mv.getIntegervalue() == null) {
                    ++nullSize;
                    continue;
                }
                if (valori.contains(mv.getIntegervalue())) continue;
                valori.add(mv.getIntegervalue());
            }
            Collections.sort(valori);
            for (Object v : valori) {
                report = report + this.myNumberFormatter.formatInLang(((Integer)v).intValue()) + " (" + this.getIntegerModeratorValueFrequence((Integer)v) + "/" + size + ")\n";
            }
        } else if (this.moderator.getModeratortype() == Moderator.continuousType) {
            valori = new ArrayList();
            for (Moderatorvalue mv : allModeratorValuesOfModerator) {
                if (mv.getContinuousvalue() == null) {
                    ++nullSize;
                    continue;
                }
                if (valori.contains(mv.getContinuousvalue())) continue;
                valori.add(mv.getContinuousvalue());
            }
            Collections.sort(valori);
            for (Object v : valori) {
                volte = 0;
                for (Moderatorvalue mv : allModeratorValuesOfModerator) {
                    if (mv.getContinuousvalue() == null || mv.getContinuousvalue().compareTo((Double)v) != 0) continue;
                    ++volte;
                }
                report = report + this.myNumberFormatter.formatInLang(((Double)v).doubleValue()) + " (" + volte + "/" + size + ")\n";
            }
        }
        report = report + "\n" + NbBundle.getMessage(ModeratorEditorPanel.class, (String)"NULLValue") + " (" + nullSize + "/" + size + ")";
        for (String x : missingLocations) {
            report = report + "\n- " + x;
        }
        return report;
    }

    public Moderator getModerator() {
        return this.moderator;
    }

    public void setModerator(Moderator moderator) {
        this.moderator = moderator;
    }

    public IApplicationManager getApplicationEventWorker() {
        return this.applicationEventWorker;
    }

    public void setApplicationEventWorker(IApplicationManager applicationEventWorker) {
        this.applicationEventWorker = applicationEventWorker;
    }
}

