/*
 * Decompiled with CFR 0.152.
 */
package metaanalyisis.guiandnodes.moderators.editors;

import formattazione.numeri.MyNumberFormatter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import metaanalsysis.guiutil.guicheckers.AbstractRole;
import metaanalsysis.guiutil.guicheckers.FieldDoubleNotNullRole;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalsysis.guiutil.guicheckers.StringNotNullRole;
import metaanalyisis.guiandnodes.moderators.editors.NumericalRolesManager;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.moderatorrecode.apis.AbstractNumericalRole;
import metaanalysis.moderatorrecode.apis.DefaultLowerNumericalRole;
import org.openide.util.NbBundle;

public class NumericalRolePanel
extends JPanel {
    private final NumericalRolesManager numericalRolesManager;
    protected GuiChecker guiChecker = new GuiChecker(TuliTuliTools.isAutoSelectContentFieldEnabled());
    private boolean correct = false;
    private final MyNumberFormatter myNumberFormatter;
    private JButton addRoleButton;
    private JLabel arrow;
    private JButton deleteRoleButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField limitValueField;
    private JTextField recodedValueField;
    private JLabel report;
    private JLabel toInfiniteLabel;
    protected AbstractNumericalRole role = null;

    public NumericalRolePanel(AbstractNumericalRole role, NumericalRolesManager numericalRolesManager, MyNumberFormatter myNumberFormatter) {
        this.myNumberFormatter = myNumberFormatter;
        this.role = role;
        this.numericalRolesManager = numericalRolesManager;
        this.initComponents();
        if (role instanceof DefaultLowerNumericalRole) {
            this.limitValueField.setText("-\u221e");
            this.limitValueField.setEditable(false);
            this.jLabel1.setText("");
            this.setProtected(true);
        } else if (role.getLowerLimit() != null) {
            this.limitValueField.setText("" + role.getLowerLimit());
        }
        this.recodedValueField.setText(role.getCodedValue());
        if (!(this.role instanceof DefaultLowerNumericalRole)) {
            this.guiChecker.addRole((AbstractRole)new FieldDoubleNotNullRole(this.limitValueField, this.role.getLowerLimit(), this.myNumberFormatter), false);
        }
        this.guiChecker.addRole((AbstractRole)new StringNotNullRole(this.recodedValueField, this.role.getCodedValue()), false);
        this.correct = this.guiChecker.checkAndFix();
        this.numericalRolesManager.aggiorna(this.correct);
        this.validate();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.arrow = new JLabel();
        this.limitValueField = new JTextField();
        this.recodedValueField = new JTextField();
        this.deleteRoleButton = new JButton();
        this.addRoleButton = new JButton();
        this.jLabel2 = new JLabel();
        this.toInfiniteLabel = new JLabel();
        this.report = new JLabel();
        this.setMaximumSize(new Dimension(330, 115));
        this.setMinimumSize(new Dimension(330, 115));
        this.setPreferredSize(new Dimension(330, 115));
        this.setSize(new Dimension(330, 115));
        this.jLabel1.setText(NbBundle.getMessage(NumericalRolePanel.class, (String)"NumericalRolePanel.jLabel1.text"));
        this.jLabel1.setSize(new Dimension(75, 16));
        this.arrow.setIcon(new ImageIcon(this.getClass().getResource("/metaanalyisis/guiandnodes/moderators/editors/arrow_down.png")));
        this.arrow.setText(NbBundle.getMessage(NumericalRolePanel.class, (String)"NumericalRolePanel.arrow.text"));
        this.limitValueField.setHorizontalAlignment(4);
        this.limitValueField.setText(NbBundle.getMessage(NumericalRolePanel.class, (String)"NumericalRolePanel.limitValueField.text"));
        this.limitValueField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                NumericalRolePanel.this.limitValueFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                NumericalRolePanel.this.limitValueFieldFocusLost(evt);
            }
        });
        this.limitValueField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NumericalRolePanel.this.limitValueFieldKeyReleased(evt);
            }
        });
        this.recodedValueField.setHorizontalAlignment(2);
        this.recodedValueField.setText(NbBundle.getMessage(NumericalRolePanel.class, (String)"NumericalRolePanel.recodedValueField.text"));
        this.recodedValueField.setToolTipText(NbBundle.getMessage(NumericalRolePanel.class, (String)"NumericalRolePanel.recodedValueField.toolTipText"));
        this.recodedValueField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                NumericalRolePanel.this.recodedValueFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                NumericalRolePanel.this.recodedValueFieldFocusLost(evt);
            }
        });
        this.recodedValueField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NumericalRolePanel.this.recodedValueFieldKeyReleased(evt);
            }
        });
        this.deleteRoleButton.setText(NbBundle.getMessage(NumericalRolePanel.class, (String)"NumericalRolePanel.deleteRoleButton.text"));
        this.deleteRoleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NumericalRolePanel.this.deleteRoleButtonActionPerformed(evt);
            }
        });
        this.addRoleButton.setText(NbBundle.getMessage(NumericalRolePanel.class, (String)"NumericalRolePanel.addRoleButton.text"));
        this.addRoleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NumericalRolePanel.this.addRoleButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setText(NbBundle.getMessage(NumericalRolePanel.class, (String)"NumericalRolePanel.jLabel2.text"));
        this.toInfiniteLabel.setText(NbBundle.getMessage(NumericalRolePanel.class, (String)"NumericalRolePanel.toInfiniteLabel.text"));
        this.report.setText(NbBundle.getMessage(NumericalRolePanel.class, (String)"NumericalRolePanel.report.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(176, 176, 176).addComponent(this.toInfiniteLabel, -2, 43, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(87, 87, 87).addComponent(this.arrow).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.report, -2, 62, -2).addComponent(this.jLabel2))).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel1, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.limitValueField, -2, 98, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.deleteRoleButton, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addRoleButton, -2, 44, -2)).addComponent(this.recodedValueField, -2, 94, -2)))).addContainerGap(5, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.limitValueField, -2, -1, -2).addComponent(this.deleteRoleButton).addComponent(this.addRoleButton).addComponent(this.jLabel1)).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.arrow).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.recodedValueField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.report, -2, 18, -2).addGap(9, 9, 9))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.toInfiniteLabel, -2, 20, -2)));
    }

    private void addRoleButtonActionPerformed(ActionEvent evt) {
        this.numericalRolesManager.addAfter(this);
    }

    private void deleteRoleButtonActionPerformed(ActionEvent evt) {
        this.numericalRolesManager.remove(this);
    }

    private void recodedValueFieldKeyReleased(KeyEvent evt) {
        this.correct = this.guiChecker.checkWhitoutFix();
        this.guiChecker.fieldChange(this.recodedValueField);
        this.numericalRolesManager.aggiorna(this.correct);
    }

    private void limitValueFieldKeyReleased(KeyEvent evt) {
        if (!(this.role instanceof DefaultLowerNumericalRole)) {
            this.correct = this.guiChecker.checkWhitoutFix();
            this.guiChecker.fieldChange(this.limitValueField);
            this.numericalRolesManager.aggiorna(this.correct);
        }
    }

    private void limitValueFieldFocusLost(FocusEvent evt) {
        if (!(this.role instanceof DefaultLowerNumericalRole)) {
            this.guiChecker.checkAndFixField(this.limitValueField);
            this.correct = this.guiChecker.checkWhitoutFix();
            this.numericalRolesManager.aggiorna(this.correct);
        }
    }

    private void recodedValueFieldFocusLost(FocusEvent evt) {
        this.guiChecker.checkAndFixField(this.recodedValueField);
        this.correct = this.guiChecker.checkWhitoutFix();
        this.numericalRolesManager.aggiorna(this.correct);
    }

    private void limitValueFieldFocusGained(FocusEvent evt) {
    }

    private void recodedValueFieldFocusGained(FocusEvent evt) {
    }

    public AbstractNumericalRole getRole() throws Exception {
        if (!this.correct) {
            throw new Exception("Error, recode role is not completed");
        }
        if (!(this.role instanceof DefaultLowerNumericalRole)) {
            this.role.setLowerLimit(this.guiChecker.getRole(this.limitValueField).getDoubleValue());
        }
        this.role.setCodedValue(this.recodedValueField.getText());
        return this.role;
    }

    public void setRole(AbstractNumericalRole role) {
        this.role = role;
    }

    public void setConsistent(boolean isCoerent) {
        Color colore = this.limitValueField.getBackground();
        if (!colore.equals(StyleProvider.correctionColor)) {
            colore = StyleProvider.rightColor;
        }
        if (isCoerent) {
            this.limitValueField.setBackground(colore);
            this.limitValueField.setToolTipText("");
            this.validate();
        } else {
            this.limitValueField.setBackground(StyleProvider.wrongColor);
            this.limitValueField.setToolTipText(NbBundle.getMessage(NumericalRolePanel.class, (String)"consistentRole"));
            this.validate();
        }
    }

    public Double getLimitValue() {
        return this.guiChecker.getRole(this.limitValueField).getDoubleValue();
    }

    public String getRecodeValue() {
        return this.recodedValueField.getText();
    }

    public void setAsLastPanel(boolean isLast) {
        if (isLast) {
            this.toInfiniteLabel.setBackground(Color.green);
            this.toInfiniteLabel.setText("+\u221e");
            this.validate();
        } else {
            this.toInfiniteLabel.setBackground(new Color(0, 0, 0, 0));
            this.toInfiniteLabel.setText("");
            this.validate();
        }
    }

    public final void setProtected(boolean isProtected) {
        if (isProtected) {
            this.deleteRoleButton.setVisible(false);
            this.validate();
        } else {
            this.deleteRoleButton.setVisible(true);
            this.validate();
        }
    }

    public void setReport(int instance, int totalInstances, String tooltip) {
        this.report.setVisible(true);
        this.report.setText("(" + instance + "/" + totalInstances + ")");
        this.report.setToolTipText(tooltip);
        this.validate();
    }

    public void unsetReport() {
        this.report.setText("");
        this.report.setVisible(false);
        this.validate();
    }

    boolean isCorrect() {
        return this.correct;
    }
}

