/*
 * Decompiled with CFR 0.152.
 */
package metaanalyisis.guiandnodes.moderators.editors;

import formattazione.numeri.MyNumberFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import metaanalyisis.guiandnodes.moderators.editors.NumericalModeratorrecodeEditorPanel;
import metaanalyisis.guiandnodes.moderators.editors.NumericalRolePanel;
import metaanalyisis.guiandnodes.moderators.editors.PiuInfinito;
import metaanalyisis.guiandnodes.moderators.functions.ModeratorsAdvancedFunctions;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorrecode;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.moderatorrecode.apis.AbstractNumericalRole;
import metaanalysis.moderatorrecode.apis.DefaultLowerNumericalRole;
import metaanalysis.moderatorrecode.apis.IRecodeRole;
import metaanalysis.moderatorrecode.apis.ModeratorRecodeMachine;
import metaanalysis.moderatorrecode.apis.NumericalRole;
import org.openide.util.Exceptions;

public class NumericalRolesManager {
    private NumericalModeratorrecodeEditorPanel containerPannel;
    protected JPanel internalPanel = null;
    protected ArrayList<NumericalRolePanel> panels = new ArrayList();
    private final Moderatorrecode moderatorrecode;
    private final IApplicationManager applicationEventWorker;
    protected MyNumberFormatter myNumberFormatter;

    public NumericalRolesManager(NumericalModeratorrecodeEditorPanel containerPannel, JPanel internalPanel, Moderatorrecode moderatorrecode, ModeratorRecodeMachine moderatorRecodeMachine, IApplicationManager applicationEventWorker) {
        this.myNumberFormatter = applicationEventWorker.getMyNumberFormatter();
        this.containerPannel = containerPannel;
        this.internalPanel = internalPanel;
        this.moderatorrecode = moderatorrecode;
        this.applicationEventWorker = applicationEventWorker;
        for (IRecodeRole role : moderatorRecodeMachine.getRoles()) {
            if (role instanceof DefaultLowerNumericalRole) {
                this.panels.add(new NumericalRolePanel((AbstractNumericalRole)((DefaultLowerNumericalRole)role), this, this.myNumberFormatter));
                continue;
            }
            if (!(role instanceof NumericalRole)) continue;
            this.panels.add(new NumericalRolePanel((AbstractNumericalRole)((NumericalRole)role), this, this.myNumberFormatter));
        }
        if (this.panels.isEmpty()) {
            NumericalRolePanel numericalRolePanel = new NumericalRolePanel((AbstractNumericalRole)new DefaultLowerNumericalRole(""), this, this.myNumberFormatter);
            this.panels.add(numericalRolePanel);
            this.internalPanel.add(numericalRolePanel);
            numericalRolePanel = new NumericalRolePanel((AbstractNumericalRole)new NumericalRole(""), this, this.myNumberFormatter);
            this.panels.add(numericalRolePanel);
            this.internalPanel.add(numericalRolePanel);
        }
        this.repaintRolesPanels();
    }

    public ModeratorRecodeMachine digestAll() {
        ModeratorRecodeMachine mrm = new ModeratorRecodeMachine();
        for (NumericalRolePanel tmp : this.panels) {
            AbstractNumericalRole fromPanelToRole = this.fromPanelToRole(tmp);
            if (fromPanelToRole == null) continue;
            mrm.getRoles().add(fromPanelToRole);
        }
        return mrm;
    }

    private AbstractNumericalRole fromPanelToRole(NumericalRolePanel panel) {
        try {
            return panel.getRole();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void addAfter(NumericalRolePanel panelBeforeInsert) {
        ArrayList<NumericalRolePanel> nuovo = new ArrayList<NumericalRolePanel>();
        for (NumericalRolePanel tmp : this.panels) {
            nuovo.add(tmp);
            if (tmp != panelBeforeInsert) continue;
            nuovo.add(new NumericalRolePanel((AbstractNumericalRole)new NumericalRole(""), this, this.myNumberFormatter));
        }
        this.panels = nuovo;
        this.repaintRolesPanels();
    }

    public void remove(NumericalRolePanel panelToRemove) {
        panelToRemove.setVisible(false);
        panelToRemove.validate();
        this.panels.remove(panelToRemove);
        this.repaintRolesPanels();
    }

    public final void repaintRolesPanels() {
        this.internalPanel.removeAll();
        this.containerPannel.validate();
        NumericalRolePanel last = null;
        for (int i = 0; i < this.panels.size(); ++i) {
            last = this.panels.get(i);
            last.setAsLastPanel(false);
            if (i > 0) {
                last.setProtected(false);
            }
            this.internalPanel.add(last);
            if (i % 2 != 0) {
                this.panels.get(i).setBackground(StyleProvider.alternativeColor1);
            } else {
                this.panels.get(i).setBackground(StyleProvider.alternativeColor2);
            }
            last.validate();
        }
        last.setAsLastPanel(true);
        if (this.panels.size() == 2) {
            last.setProtected(true);
        }
        last.validate();
        PiuInfinito piuInfinito = new PiuInfinito();
        this.internalPanel.add(piuInfinito);
        if (this.panels.size() % 2 != 0) {
            piuInfinito.setBackground(StyleProvider.alternativeColor1);
        } else {
            piuInfinito.setBackground(StyleProvider.alternativeColor2);
        }
        this.aggiorna(true);
        this.containerPannel.refreshContenitori();
    }

    private boolean checkFormat() {
        boolean comeVa = true;
        for (NumericalRolePanel tmp : this.panels) {
            if (tmp.isCorrect()) continue;
            comeVa = false;
        }
        return comeVa;
    }

    private boolean controllaInterDipendenza() {
        if (!this.checkFormat()) {
            return false;
        }
        boolean corretto = true;
        double lastValue = Double.MIN_VALUE;
        for (int i = 1; i < this.panels.size(); ++i) {
            if (this.panels.get(i).getLimitValue() <= lastValue) {
                this.panels.get(i).setConsistent(false);
                corretto = false;
            } else {
                this.panels.get(i).setConsistent(true);
            }
            lastValue = this.panels.get(i).getLimitValue();
        }
        this.setReports(corretto);
        return corretto;
    }

    public void aggiorna(boolean singleRoleIntegrity) {
        if (!singleRoleIntegrity) {
            this.containerPannel.setSavable(false);
        } else {
            this.containerPannel.setSavable(this.controllaInterDipendenza());
        }
    }

    public ArrayList<NumericalRolePanel> getPanels() {
        return this.panels;
    }

    public void setPanels(ArrayList<NumericalRolePanel> panels) {
        this.panels = panels;
    }

    public void setReports(boolean isValid) {
        if (isValid) {
            Moderator moderator = this.applicationEventWorker.getIDataFunction().getModerator(this.moderatorrecode.getModeratorId().intValue());
            List allModeratorValuesOfModerator = this.applicationEventWorker.getIDataFunction().getAllModeratorValuesOfModerator(this.moderatorrecode.getModeratorId().intValue());
            int size = allModeratorValuesOfModerator.size();
            ArrayList valori = new ArrayList();
            ArrayList<NumericalRolePanel> pannelli = new ArrayList<NumericalRolePanel>();
            pannelli.addAll(this.panels);
            Collections.reverse(pannelli);
            for (NumericalRolePanel pannello : pannelli) {
                ArrayList<String> studiesNames = new ArrayList<String>();
                int volte = 0;
                ArrayList<Moderatorvalue> daTogliere = new ArrayList<Moderatorvalue>();
                for (Moderatorvalue mv : allModeratorValuesOfModerator) {
                    try {
                        if ((moderator.getModeratortype() != Moderator.integerType || mv.getIntegervalue() == null || !pannello.getRole().match((double)mv.getIntegervalue().intValue())) && (moderator.getModeratortype() != Moderator.continuousType || mv.getContinuousvalue() == null || !pannello.getRole().match(mv.getContinuousvalue().doubleValue()))) continue;
                        ++volte;
                        studiesNames.add(ModeratorsAdvancedFunctions.getCompleteNameOfModeratorValue(mv, this.applicationEventWorker));
                        daTogliere.add(mv);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                allModeratorValuesOfModerator.removeAll(daTogliere);
                String tt = "<html>";
                String pre = "";
                for (String s : studiesNames) {
                    tt = tt + pre + s;
                    pre = "<br/>";
                }
                pannello.setReport(volte, size, tt + "</html>");
            }
        } else {
            for (NumericalRolePanel pannello : this.panels) {
                pannello.unsetReport();
            }
        }
    }
}

