/*
 * Decompiled with CFR 0.152.
 */
package metaanalyisis.guiandnodes.moderators.tables;

import formattazione.numeri.MyNumberFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import metaanalyisis.guiandnodes.moderators.ModeratoValueComparatorAscending;
import metaanalyisis.guiandnodes.moderators.tables.StringModertatorStatisticRowBean;
import metaanalyisis.guiandnodes.moderators.tables.TableModelModertorReport;
import metaanalyisis.guiandnodes.moderators.tables.TableModeratorReport;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.DatabaseTreeNullException;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorlevel;
import metaanalysis.core.persistence.ModeratorlevelId;
import metaanalysis.core.persistence.Moderatorvalue;
import org.openide.util.NbBundle;

public class ModeratorStatisticBuilder {
    private final Moderator m;
    private final IApplicationManager iApplicationManager;
    protected MyNumberFormatter myNumberFormatter;
    private List<StringModertatorStatisticRowBean> rows = new ArrayList<StringModertatorStatisticRowBean>();

    public ModeratorStatisticBuilder(Moderator m, IApplicationManager iApplicationManager) {
        this.myNumberFormatter = iApplicationManager.getMyNumberFormatter();
        this.m = m;
        this.iApplicationManager = iApplicationManager;
    }

    public TableModeratorReport build() {
        boolean treeError = false;
        this.rows = new ArrayList<StringModertatorStatisticRowBean>();
        List allModeratorValuesOfModerator = this.iApplicationManager.getIDataFunction().getAllModeratorValuesOfModerator(this.m);
        int instances = allModeratorValuesOfModerator.size();
        if (instances > 1) {
            Collections.sort(allModeratorValuesOfModerator, new ModeratoValueComparatorAscending());
        }
        while (allModeratorValuesOfModerator.size() > 0) {
            Moderatorvalue perno = (Moderatorvalue)allModeratorValuesOfModerator.get(0);
            ArrayList<Moderatorvalue> trovati = new ArrayList<Moderatorvalue>();
            for (Moderatorvalue mv : allModeratorValuesOfModerator) {
                if (!mv.hasSameValue(perno)) continue;
                trovati.add(mv);
            }
            try {
                this.rows.add(this.buildRow(trovati, instances));
            }
            catch (DatabaseTreeNullException ex) {
                treeError = true;
            }
            for (Moderatorvalue mv : trovati) {
                allModeratorValuesOfModerator.remove(mv);
            }
        }
        if (treeError) {
            TuliTuliTools.whatAnError((String)NbBundle.getMessage(ModeratorStatisticBuilder.class, (String)"errorModerator.tree"));
        }
        return new TableModeratorReport(new TableModelModertorReport(this.rows), this.myNumberFormatter);
    }

    private StringModertatorStatisticRowBean buildRow(List<Moderatorvalue> mvs, int instances) throws DatabaseTreeNullException {
        String[] locations = new String[mvs.size()];
        for (int i = 0; i < mvs.size(); ++i) {
            Moderatorlevel moderatorlevel = this.iApplicationManager.getIDataFunction().getModeratorlevel(new ModeratorlevelId(mvs.get(i).getId().getModeratorId(), mvs.get(i).getId().getStudyId()));
            if (mvs.get(i).isStudyLinked()) {
                locations[i] = this.iApplicationManager.getIDataFunction().getStudy(mvs.get(i).getId().getStudyId()).getName();
                continue;
            }
            if (moderatorlevel.getModeratorlevel() == Moderatorlevel.outcomebranchLevel) {
                locations[i] = this.iApplicationManager.getIDataFunction().getOutcomebranchCompleteName(mvs.get(i).getId().getLongidgenId()).getCompositeName();
                continue;
            }
            if (moderatorlevel.getModeratorlevel() == Moderatorlevel.timepointbranchLevel) {
                locations[i] = this.iApplicationManager.getIDataFunction().getTimepointbranchCompleteName(mvs.get(i).getId().getLongidgenId()).getCompositeName();
                continue;
            }
            if (moderatorlevel.getModeratorlevel() == Moderatorlevel.comparisonbranchLevel) {
                locations[i] = this.iApplicationManager.getIDataFunction().getComparisonbranchCompleteName(mvs.get(i).getId().getLongidgenId()).getCompositeName();
                continue;
            }
            if (moderatorlevel.getModeratorlevel() != Moderatorlevel.subgroupbranchLevel) continue;
            locations[i] = this.iApplicationManager.getIDataFunction().getSubgroupbranchCompleteName(mvs.get(i).getId().getLongidgenId()).getCompositeName();
        }
        StringModertatorStatisticRowBean msrb = new StringModertatorStatisticRowBean("", "" + mvs.size() + "/" + instances, locations);
        if (mvs.get(0).isNull()) {
            msrb.setValue(NbBundle.getMessage(TableModelModertorReport.class, (String)"missingdata"));
        } else if (mvs.get(0).getModeratortype() == Moderator.categoricalType) {
            msrb.setValue(mvs.get(0).getCategoricalvalue());
        } else if (mvs.get(0).getModeratortype() == Moderator.integerType) {
            msrb.setValue(this.myNumberFormatter.formatInLang(mvs.get(0).getIntegervalue().intValue()));
        } else if (mvs.get(0).getModeratortype() == Moderator.continuousType) {
            msrb.setValue(this.myNumberFormatter.formatInLang(mvs.get(0).getContinuousvalue().doubleValue()));
        }
        return msrb;
    }
}

