/*
 * Decompiled with CFR 0.152.
 */
package internovi.guifields.api;

import internovi.guifields.api.IGuiField;
import java.awt.Color;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JTextArea;
import javax.swing.event.UndoableEditListener;
import org.openide.awt.UndoRedo;

public class JTextAreaGuiField
implements IGuiField {
    private final JTextArea field;
    private ArrayList<KeyListener> keyListeners = new ArrayList();
    private ArrayList<FocusListener> focusListeners = new ArrayList();

    public JTextAreaGuiField(JTextArea field) {
        this.field = field;
    }

    public JTextArea getField() {
        return this.field;
    }

    @Override
    public String getText() {
        return this.field.getText();
    }

    @Override
    public void setText(String text) {
        this.field.setText(text);
    }

    @Override
    public void setToolTipText(String text) {
        this.field.setToolTipText(text);
    }

    @Override
    public void setBackground(Color color) {
        this.field.setBackground(color);
    }

    @Override
    public void addUndoableEditListener(UndoRedo.Manager manager) {
        this.field.getDocument().addUndoableEditListener((UndoableEditListener)manager);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.field.addKeyListener(keyListener);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        this.field.addFocusListener(focusListener);
    }

    @Override
    public void selectAll() {
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.field.removeKeyListener(keyListener);
        this.keyListeners.remove(keyListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.field.removeFocusListener(focusListener);
        this.focusListeners.remove(focusListener);
    }

    @Override
    public void removeAllListeners() {
        while (!this.focusListeners.isEmpty()) {
            this.removeFocusListener(this.focusListeners.get(0));
        }
        while (!this.keyListeners.isEmpty()) {
            this.removeKeyListener(this.keyListeners.get(0));
        }
    }
}

