/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.spi;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.html.boot.impl.FnContext;

public abstract class Fn {
    private final Presenter presenter;
    private static final Map<String, Set<Presenter>> LOADED = new HashMap<String, Set<Presenter>>();

    @Deprecated
    protected Fn() {
        this(null);
    }

    protected Fn(Presenter presenter) {
        this.presenter = presenter;
    }

    public final boolean isValid() {
        return this.presenter != null && FnContext.currentPresenter(false) == this.presenter;
    }

    public static boolean isValid(Fn fnOrNull) {
        return fnOrNull != null && fnOrNull.isValid();
    }

    public static Fn define(Class<?> caller, String code, String ... names) {
        return Fn.define(caller, false, code, names);
    }

    public static Fn define(Class<?> caller, boolean keepParametersAlive, String code, String ... names) {
        Presenter p = FnContext.currentPresenter(false);
        if (p == null) {
            return null;
        }
        if (p instanceof KeepAlive) {
            boolean[] arr;
            if (!keepParametersAlive && names.length > 0) {
                arr = new boolean[names.length];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = false;
                }
            } else {
                arr = null;
            }
            return ((KeepAlive)((Object)p)).defineFn(code, names, arr);
        }
        return p.defineFn(code, names);
    }

    public static Fn preload(final Fn fn, final Class<?> caller, final String resource) {
        if (fn == null) {
            return null;
        }
        return new Fn(fn.presenter()){

            @Override
            public Object invoke(Object thiz, Object ... args) throws Exception {
                this.loadResource();
                return fn.invoke(thiz, args);
            }

            @Override
            public void invokeLater(Object thiz, Object ... args) throws Exception {
                this.loadResource();
                fn.invokeLater(thiz, args);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void loadResource() throws Exception {
                Presenter p = this.presenter();
                if (p == null) {
                    p = FnContext.currentPresenter(false);
                }
                if (p != null) {
                    HashSet<Presenter> there = (HashSet<Presenter>)LOADED.get(resource);
                    if (there == null) {
                        there = new HashSet<Presenter>();
                        LOADED.put(resource, there);
                    }
                    if (there.add(p)) {
                        ClassLoader l = caller.getClassLoader();
                        InputStream is = l.getResourceAsStream(resource);
                        if (is == null && resource.startsWith("/")) {
                            is = l.getResourceAsStream(resource.substring(1));
                        }
                        if (is == null) {
                            throw new IOException("Cannot find " + resource + " in " + l);
                        }
                        try {
                            InputStreamReader r = new InputStreamReader(is, "UTF-8");
                            p.loadScript(r);
                        }
                        finally {
                            is.close();
                        }
                    }
                }
            }
        };
    }

    public static Presenter activePresenter() {
        return FnContext.currentPresenter(false);
    }

    public static Closeable activate(Presenter p) {
        return FnContext.activate(p);
    }

    public abstract Object invoke(Object var1, Object ... var2) throws Exception;

    public void invokeLater(Object thiz, Object ... args) throws Exception {
        this.invoke(thiz, args);
    }

    protected final Presenter presenter() {
        return this.presenter;
    }

    public static interface FromJavaScript {
        public Object toJava(Object var1);
    }

    public static interface KeepAlive {
        public Fn defineFn(String var1, String[] var2, boolean[] var3);
    }

    public static interface Presenter {
        public Fn defineFn(String var1, String ... var2);

        public void displayPage(URL var1, Runnable var2);

        public void loadScript(Reader var1) throws Exception;
    }

    public static interface ToJavaScript {
        public Object toJavaScript(Object var1);
    }
}

