/*
 * Decompiled with CFR 0.152.
 */
package formattazione.numeri;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class MyNumberFormatter {
    private RoundingMode roundingMode;
    private Locale locale;
    private boolean groupingDisplayed;
    DecimalFormatSymbols symbols;

    public MyNumberFormatter(Locale locale, boolean groupingDisplayed, RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
        this.locale = locale;
        this.groupingDisplayed = groupingDisplayed;
        this.symbols = new DecimalFormatSymbols(this.getLocale());
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public boolean isGroupingDisplayed() {
        return this.groupingDisplayed;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public DecimalFormat getDecimalFormatForDouble(int decimal) {
        if (decimal < 0) {
            decimal = 0;
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(this.getLocale());
        String pattern = "##0.";
        if (this.isGroupingDisplayed()) {
            pattern = "###,##0.";
        }
        for (int i = 0; i < decimal; ++i) {
            pattern = pattern + "0";
        }
        DecimalFormat fd = new DecimalFormat(pattern, symbols);
        fd.setRoundingMode(this.getRoundingMode());
        return fd;
    }

    public String formatDouble(Double value, int decimal) {
        return this.formatDouble(value, decimal, false);
    }

    public String formatDouble(Double value, int decimal, boolean cutted) {
        try {
            String formatDouble = this.getDecimalFormatForDouble(decimal).format(value);
            if (cutted) {
                while (formatDouble.endsWith("0")) {
                    formatDouble = formatDouble.substring(0, formatDouble.length() - 1);
                }
                if (formatDouble.endsWith("" + this.symbols.getDecimalSeparator())) {
                    formatDouble = formatDouble.substring(0, formatDouble.length() - 1);
                }
            }
            return formatDouble;
        }
        catch (Exception e) {
            return "" + value;
        }
    }

    public String to3d(Double d) {
        return this.formatDouble(d, 3);
    }

    public String to2d(Double d) {
        return this.formatDouble(d, 2);
    }

    public String intero(Integer d) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(this.getLocale());
        String pattern = "#0";
        if (this.isGroupingDisplayed()) {
            pattern = "###,##0";
        }
        DecimalFormat fd = new DecimalFormat(pattern, symbols);
        if (d == null) {
            return null;
        }
        return fd.format(d);
    }

    public String formatInLang(int i) {
        return this.intero(i);
    }

    public String formatInLang(double d) {
        String formatDouble = this.formatDouble(d, 20);
        while (formatDouble.endsWith("0")) {
            formatDouble = formatDouble.substring(0, formatDouble.length() - 1);
        }
        if (formatDouble.endsWith(".") || formatDouble.endsWith(",")) {
            formatDouble = formatDouble.substring(0, formatDouble.length() - 1);
        }
        return formatDouble;
    }

    public NumberFormat getNumberFormat(int maxDecimals) {
        NumberFormat numberFormat = NumberFormat.getInstance(this.locale);
        numberFormat.setGroupingUsed(this.groupingDisplayed);
        numberFormat.setRoundingMode(this.roundingMode);
        numberFormat.setMaximumFractionDigits(maxDecimals);
        return numberFormat;
    }
}

