/*
 * Decompiled with CFR 0.152.
 */
package effectsizeplot.core;

import effectsizeplot.api.AEffectSizeEditorPanel;
import effectsizeplot.api.IEffectSizeSource;
import effectsizeplot.core.CipFileWrapper;
import filemanager.events.SaveFileEvent;
import filemanager.events.ToSaveFileEvent;
import filemanager.tools.FileManagerException;
import filemanager.tools.FileTools;
import filemanager.tools.IMultiFileManager;
import filemanager.tools.ISourceWrapper;
import filemanager.tools.cookies.SavableFileManagerCookie;
import gui.alerts.GuiAlerts;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="EffectSizeEditorTopComponent", iconBase="effectsizeplot/core/cippy.png", persistenceType=2)
public class CipEditorWindow
extends TopComponent
implements Lookup.Provider,
PropertyChangeListener {
    private SavableFileManagerCookie savableCookie;
    private ISourceWrapper wrappedSource;
    private InstanceContent content;
    private Lookup lookup;
    private IMultiFileManager t;
    AEffectSizeEditorPanel editor;
    private boolean savableFlag = false;

    public CipEditorWindow() {
        this.initComponents();
        this.content = new InstanceContent();
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.content);
        this.t = (IMultiFileManager)Lookup.getDefault().lookup(IMultiFileManager.class);
        this.t.addPropertyChangeListener((PropertyChangeListener)this);
        try {
            this.wrappedSource = this.t.getEvent().getFile();
            CipFileWrapper cfw = (CipFileWrapper)this.wrappedSource;
            if (cfw.getObject() != null) {
                this.savableCookie = new SavableFileManagerCookie(this.wrappedSource);
                this.editor = cfw.getObject().getEditor();
                this.editor.addPropertyChangeListener((PropertyChangeListener)this);
                this.add((Component)this.editor);
                this.validate();
                this.content.add(this.wrappedSource.getObject());
                this.content.add((Object)this.wrappedSource);
                if (this.wrappedSource.getObject() instanceof IEffectSizeSource) {
                    ((IEffectSizeSource)this.wrappedSource.getObject()).getVisualizerBean().addPropertyChangeListener((PropertyChangeListener)this);
                }
                this.setName(FileTools.getFileName((String)cfw.getName()));
            } else {
                GuiAlerts.whatAnError((String)"Null source");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public int getPersistenceType() {
        return 2;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("event")) {
            ToSaveFileEvent event;
            if (pce.getNewValue() instanceof SaveFileEvent) {
                SaveFileEvent event2 = (SaveFileEvent)pce.getNewValue();
                if (event2.getSourceFile() == this.wrappedSource) {
                    this.content.remove((Object)this.savableCookie);
                    this.savableFlag = false;
                }
            } else if (pce.getNewValue() instanceof ToSaveFileEvent && (event = (ToSaveFileEvent)pce.getNewValue()).getSourceFile() == this.wrappedSource && !this.savableFlag) {
                this.content.add((Object)this.savableCookie);
                this.savableFlag = true;
                this.validate();
            }
        } else if (!this.savableFlag) {
            this.content.add((Object)this.savableCookie);
            this.savableFlag = true;
        }
    }

    protected void componentClosed() {
        boolean doYouWantDoTheRightAction;
        super.componentClosed();
        if (this.savableFlag && (doYouWantDoTheRightAction = GuiAlerts.doYouWantDoTheRightAction((String)("Do you want save " + this.wrappedSource.getName())))) {
            try {
                this.t.saveFile(this.wrappedSource);
            }
            catch (FileManagerException ex) {
                GuiAlerts.whatAnError((String)"Impossible to save");
            }
        }
        this.t.closeFile(this.wrappedSource);
        this.t.removePropertyChangeListener((PropertyChangeListener)this);
        try {
            this.editor.removePropertyChangeListener((PropertyChangeListener)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.wrappedSource.getObject() instanceof IEffectSizeSource) {
            try {
                ((IEffectSizeSource)this.wrappedSource.getObject()).getVisualizerBean().removePropertyChangeListener((PropertyChangeListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isSavableFlag() {
        return this.savableFlag;
    }

    public void setSavableFlag(boolean savableFlag) {
        this.savableFlag = savableFlag;
    }

    public ISourceWrapper getWrappedSource() {
        return this.wrappedSource;
    }

    public IMultiFileManager getT() {
        return this.t;
    }

    public AEffectSizeEditorPanel getEditor() {
        return this.editor;
    }
}

