/*
 * Decompiled with CFR 0.152.
 */
package effectsizeplot.core;

import effectsizeplot.api.IEffectSizeSource;
import effectsizeplot.core.CipFileWrapper;
import filemanager.tools.IFileSourceReaderAndWriter;
import filemanager.tools.ISourceWrapper;
import filemanager.tools.SourceFileNotSupported;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.openide.util.Exceptions;

public class CipFileReaderAndWriter
implements IFileSourceReaderAndWriter {
    public ISourceWrapper readSource(String location) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(location);
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        XMLDecoder d = new XMLDecoder(new BufferedInputStream(fis));
        IEffectSizeSource result = (IEffectSizeSource)d.readObject();
        d.close();
        return new CipFileWrapper(result, location);
    }

    public void saveSource(ISourceWrapper sourceWrapper, String location) throws SourceFileNotSupported {
        try {
            FileOutputStream fos = new FileOutputStream(location);
            sourceWrapper.save((OutputStream)fos);
            fos.close();
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getExtension() {
        return ".cip";
    }

    public String getDescription() {
        return "CIP Confidence Interval Plotter File";
    }
}

