/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.persistence;

import java.io.Serializable;
import java.util.Arrays;
import metaanalysis.application.tools.SpeedyCopy;

public class Moderator
implements Serializable,
Comparable<Moderator>,
SpeedyCopy<Moderator> {
    private int id;
    private String name;
    private String description;
    private Integer moderatortype;
    private String defvalues;
    private String note;
    private Long topicId;
    private String systemlevel;
    public static int categoricalType = 3;
    public static int integerType = 1;
    public static int continuousType = 2;
    public static String standardSystemLevel = "standard";
    public static String publicationYearSystemLevel = "publicationYear";
    public static String publicationTypeSystemLevel = "publicationType";

    public Moderator() {
    }

    public Moderator(int id, String systemlevel) {
        this.id = id;
        this.systemlevel = systemlevel;
    }

    public Moderator(int id, String name, String description, Integer moderatortype, String defvalues, String note, Long topicId, String systemlevel) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.moderatortype = moderatortype;
        this.defvalues = defvalues;
        this.note = note;
        this.topicId = topicId;
        this.systemlevel = systemlevel;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getModeratortype() {
        return this.moderatortype;
    }

    public void setModeratortype(Integer moderatortype) {
        this.moderatortype = moderatortype;
    }

    public String getDefvalues() {
        return this.defvalues;
    }

    public void setDefvalues(String defvalues) {
        this.defvalues = defvalues;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Long getTopicId() {
        return this.topicId;
    }

    public void setTopicId(Long topicId) {
        this.topicId = topicId;
    }

    public String getSystemlevel() {
        return this.systemlevel;
    }

    public void setSystemlevel(String systemlevel) {
        this.systemlevel = systemlevel;
    }

    public void copyFrom(Moderator moderator) {
        this.id = moderator.getId();
        this.name = moderator.getName();
        this.description = moderator.getDescription();
        this.defvalues = moderator.getDefvalues();
        this.note = moderator.getNote();
        this.topicId = moderator.getTopicId();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Moderator t) {
        return this.getName().compareTo(t.getName());
    }

    public Moderator duplicate() {
        return new Moderator(this.id, this.name, this.description, this.moderatortype, this.defvalues, this.note, this.topicId, this.systemlevel);
    }

    public static String fixDefaultValues(String valueToFix, boolean reorder) {
        String correct = "";
        while (valueToFix.indexOf("\n\n") != -1) {
            valueToFix = valueToFix.replaceAll("\n\n", "\n");
        }
        Object[] splitted = valueToFix.split("\n");
        if (reorder) {
            Arrays.sort(splitted);
        }
        String acapo = "";
        Object lastString = "";
        for (Object tmp : splitted) {
            if (((String)tmp).equals(lastString)) continue;
            correct = correct + acapo + (String)tmp;
            acapo = "\n";
            lastString = tmp;
        }
        return correct;
    }

    public static String[] getDefaultValuesIntoArray(String values) {
        if (values == null) {
            return new String[0];
        }
        return values.split("\n");
    }

    public static String getDefaultValuesFromAnArray(String[] s) {
        String ret = "";
        Arrays.sort(s);
        String acapo = "";
        for (String tmp : s) {
            ret = ret + acapo;
            ret = ret + tmp;
            acapo = "\n";
        }
        return ret;
    }

    public static String digestFilteredDefaultValuesFromAString(String s) {
        return Moderator.getDefaultValuesFromAnArray(Moderator.getDefaultValuesIntoArray(s));
    }
}

