/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.core.persistence;

import java.io.Serializable;
import metaanalysis.application.tools.SpeedyCopy;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.ModeratorvalueId;

public class Moderatorvalue
implements Serializable,
SpeedyCopy<Moderatorvalue> {
    private ModeratorvalueId id;
    private Integer moderatortype;
    private String categoricalvalue;
    private Integer integervalue;
    private Double continuousvalue;
    private String note;
    public static final String PROP_NOTE = "note";
    public static final String PROP_INTEGERVALUE = "integervalue";
    public static final String PROP_CONTINUOUSVALUE = "continuousvalue";
    public static final String PROP_CATEGORICALVALUE = "categoricalvalue";

    public Moderatorvalue() {
    }

    public Moderatorvalue(ModeratorvalueId id) {
        this.id = id;
    }

    public Moderatorvalue(ModeratorvalueId id, Integer moderatortype, String categoricalvalue, Integer integervalue, Double continuousvalue, String note) {
        this.id = id;
        this.moderatortype = moderatortype;
        this.categoricalvalue = categoricalvalue;
        this.integervalue = integervalue;
        this.continuousvalue = continuousvalue;
        this.note = note;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Integer getIntegervalue() {
        return this.integervalue;
    }

    public void setIntegervalue(Integer integervalue) {
        this.integervalue = integervalue;
    }

    public Double getContinuousvalue() {
        return this.continuousvalue;
    }

    public Double getNumericalValue() {
        if (this.moderatortype == Moderator.continuousType) {
            return this.getContinuousvalue();
        }
        if (this.moderatortype == Moderator.integerType) {
            if (this.getIntegervalue() == null) {
                return null;
            }
            return new Double(this.getIntegervalue().intValue());
        }
        return null;
    }

    public void setContinuousvalue(Double continuousvalue) {
        this.continuousvalue = continuousvalue;
    }

    public String getCategoricalvalue() {
        return this.categoricalvalue;
    }

    public void setCategoricalvalue(String categoricalvalue) {
        this.categoricalvalue = categoricalvalue;
    }

    public ModeratorvalueId getId() {
        return this.id;
    }

    public void setId(ModeratorvalueId id) {
        this.id = id;
    }

    public Integer getModeratortype() {
        return this.moderatortype;
    }

    public void setModeratortype(Integer moderatortype) {
        this.moderatortype = moderatortype;
    }

    public Moderatorvalue clone() {
        return new Moderatorvalue(this.id, this.moderatortype, this.categoricalvalue, this.integervalue, this.continuousvalue, this.note);
    }

    public void copyFrom(Moderatorvalue obj) {
        this.id = obj.getId().duplicate();
        this.categoricalvalue = obj.getCategoricalvalue();
        this.continuousvalue = obj.getContinuousvalue();
        this.integervalue = obj.getIntegervalue();
        this.moderatortype = obj.getModeratortype();
        this.note = obj.getNote();
    }

    public boolean hasSameValue(Moderatorvalue mv) {
        if (this.getCategoricalvalue() != null || mv.getCategoricalvalue() != null) {
            if (this.getCategoricalvalue() == null || mv.getCategoricalvalue() == null) {
                return false;
            }
            if (!this.getCategoricalvalue().equals(mv.getCategoricalvalue())) {
                return false;
            }
        }
        if (this.getContinuousvalue() != null || mv.getContinuousvalue() != null) {
            if (this.getContinuousvalue() == null || mv.getContinuousvalue() == null) {
                return false;
            }
            if (this.getContinuousvalue().doubleValue() != mv.getContinuousvalue().doubleValue()) {
                return false;
            }
        }
        if (this.getIntegervalue() != null || mv.getIntegervalue() != null) {
            if (this.getIntegervalue() == null || mv.getIntegervalue() == null) {
                return false;
            }
            if (this.getIntegervalue().intValue() != mv.getIntegervalue().intValue()) {
                return false;
            }
        }
        return true;
    }

    public Moderatorvalue duplicate() {
        return new Moderatorvalue(this.id.duplicate(), this.moderatortype, this.categoricalvalue, this.integervalue, this.continuousvalue, this.note);
    }

    public boolean isNull() {
        return this.getCategoricalvalue() == null && this.getContinuousvalue() == null && this.getIntegervalue() == null;
    }

    public boolean isStudyLinked() {
        return this.getId().getStudyId() == this.getId().getLongidgenId();
    }
}

