/*
 * Decompiled with CFR 0.152.
 */
package internovi.numbers.locale.provider;

import java.util.List;
import java.util.Locale;
import org.openide.util.NbPreferences;

public class LocaleNumbersProvider {
    private static String numbersLangagesVariable = "numbersLanguage";
    private static String numbersLangageSelectedVariable = "numbersLangageSelected";
    private static String displayGroupSeparatorVariable = "displayGroupSeparator";
    public static String italiano = "Italiano 1.234,56";
    public static String english = "English 1,234.56";

    public static Locale getLocale() {
        if (LocaleNumbersProvider.getSelectedLangage().equals(italiano)) {
            return Locale.ITALIAN;
        }
        return Locale.ENGLISH;
    }

    public static void saveSelectedLangage(String selectedLanguage) {
        NbPreferences.root().put(numbersLangageSelectedVariable, selectedLanguage);
    }

    public static String getSelectedLangage() {
        return NbPreferences.root().get(numbersLangageSelectedVariable, english);
    }

    public static void saveUsableLangages(List<String> usableLanguages) {
        boolean prima = true;
        String tmp = "";
        for (String x : usableLanguages) {
            if (!prima) {
                tmp = tmp + "!";
            } else {
                prima = false;
            }
            tmp = tmp + x;
        }
        NbPreferences.root().put(numbersLangagesVariable, tmp);
    }

    public static void saveUsableLangages(String[] usableLanguages) {
        boolean prima = true;
        String tmp = "";
        for (String x : usableLanguages) {
            if (!prima) {
                tmp = tmp + "!";
            } else {
                prima = false;
            }
            tmp = tmp + x;
        }
        NbPreferences.root().put(numbersLangagesVariable, tmp);
    }

    public static String[] getUsableLangages() {
        return NbPreferences.root().get(numbersLangagesVariable, english).split("!");
    }

    public static void saveGroupSeparatorDisplay(boolean isDisplayed) {
        if (isDisplayed) {
            NbPreferences.root().put(displayGroupSeparatorVariable, "true");
        } else {
            NbPreferences.root().put(displayGroupSeparatorVariable, "false");
        }
    }

    public static boolean isGroupSeparatorDisplayed() {
        String get = NbPreferences.root().get(displayGroupSeparatorVariable, "false");
        return get.equals("true");
    }
}

