/*
 * Decompiled with CFR 0.152.
 */
package filemanager.tools;

import filemanager.events.IFileToolsEvent;
import filemanager.events.OpenFileEvent;
import filemanager.events.SaveFileEvent;
import filemanager.tools.CloseFileEvent;
import filemanager.tools.FileAllocator;
import filemanager.tools.FileManagerException;
import filemanager.tools.FileTools;
import filemanager.tools.IFileSourceReaderAndWriter;
import filemanager.tools.IMultiFileManager;
import filemanager.tools.ISourceWrapper;
import filemanager.tools.SourceFileAlreadyOpened;
import filemanager.tools.SourceFileNotSupported;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFileManager
implements IMultiFileManager {
    private int handlerCapacity;
    private int recentlyCapacity;
    private List<FileAllocator> allocators = new ArrayList<FileAllocator>();
    private List<IFileSourceReaderAndWriter> fileReaderAndWriters = new ArrayList<IFileSourceReaderAndWriter>();
    private List<String> recentlyLocations = new ArrayList<String>();
    private IFileToolsEvent event;
    public static final String PROP_EVENT = "event";
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public AbstractFileManager(int handlerCapacity, int recentlyCapacity) throws FileManagerException {
        if (recentlyCapacity < 1 || handlerCapacity < 1) {
            throw new FileManagerException("The setted capacity is < 1");
        }
        this.handlerCapacity = handlerCapacity;
        this.recentlyCapacity = recentlyCapacity;
    }

    public AbstractFileManager() throws FileManagerException {
        this.handlerCapacity = 50;
        this.recentlyCapacity = 10;
    }

    @Override
    public List<IFileSourceReaderAndWriter> getFileReaderAndWriters() {
        return this.fileReaderAndWriters;
    }

    public void setFileReaderAndWriters(List<IFileSourceReaderAndWriter> fileReaderAndWriters) {
        this.fileReaderAndWriters = fileReaderAndWriters;
    }

    private IFileSourceReaderAndWriter dammiIlLettoreGiusto(String extension) {
        if (extension == null) {
            return null;
        }
        for (IFileSourceReaderAndWriter xxx : this.fileReaderAndWriters) {
            if (!xxx.getExtension().equals(extension)) continue;
            return xxx;
        }
        return null;
    }

    @Override
    public ISourceWrapper addFile(String location) throws FileManagerException {
        for (FileAllocator fa : this.allocators) {
            if (!fa.getLocation().equals(location)) continue;
            throw new SourceFileAlreadyOpened(location);
        }
        String extension = FileTools.getExtension(location);
        if (extension == null) {
            throw new SourceFileNotSupported(extension);
        }
        IFileSourceReaderAndWriter dammiIlLettoreGiusto = this.dammiIlLettoreGiusto(extension);
        if (dammiIlLettoreGiusto == null) {
            throw new SourceFileNotSupported(extension);
        }
        ISourceWrapper readSource = dammiIlLettoreGiusto.readSource(location);
        FileAllocator fa = new FileAllocator(location, readSource);
        if (this.allocators.size() >= this.handlerCapacity) {
            this.allocators.remove(0);
        }
        this.allocators.add(fa);
        this.recentlyLocations.remove(location);
        this.recentlyLocations.add(location);
        if (this.recentlyLocations.size() >= this.recentlyCapacity) {
            this.recentlyLocations.remove(0);
        }
        this.setEvent(new OpenFileEvent(readSource));
        return readSource;
    }

    @Override
    public void closeFile(ISourceWrapper iSourceWrapper) {
        FileAllocator toRemove = null;
        for (FileAllocator fa : this.allocators) {
            if (fa.getSource() != iSourceWrapper) continue;
            toRemove = fa;
            break;
        }
        if (toRemove != null) {
            this.allocators.remove(toRemove);
            this.setEvent(new CloseFileEvent(toRemove.getSource()));
        }
    }

    @Override
    public void saveFile(ISourceWrapper iSourceWrapper) throws SourceFileNotSupported {
        FileAllocator fileAllocator = this.getFileAllocator(iSourceWrapper);
        IFileSourceReaderAndWriter dammiIlLettoreGiusto = this.dammiIlLettoreGiusto(FileTools.getExtension(fileAllocator.getLocation()));
        dammiIlLettoreGiusto.saveSource(fileAllocator.getSource(), fileAllocator.getLocation());
        this.setEvent(new SaveFileEvent(fileAllocator.getSource()));
    }

    private FileAllocator getFileAllocator(ISourceWrapper iSourceWrapper) {
        for (FileAllocator fa : this.allocators) {
            if (fa.getSource() != iSourceWrapper) continue;
            return fa;
        }
        return null;
    }

    @Override
    public List<String> getRecentlyLocations() {
        return this.recentlyLocations;
    }

    public void setRecentlyLocations(List<String> recentlyLocations) {
        this.recentlyLocations = recentlyLocations;
    }

    @Override
    public void changeLocationAndSave(ISourceWrapper iSourceWrapper, String newLocation) throws FileManagerException {
        for (FileAllocator fa : this.allocators) {
            if (!fa.getLocation().equals(newLocation) || fa.getSource() == iSourceWrapper) continue;
            throw new SourceFileAlreadyOpened();
        }
        FileAllocator fileAllocator = this.getFileAllocator(iSourceWrapper);
        String oldLocation = fileAllocator.getLocation();
        fileAllocator.setLocation(newLocation);
        this.saveFile(iSourceWrapper);
        this.recentlyLocations.remove(oldLocation);
        this.setEvent(new SaveFileEvent(fileAllocator.getSource()));
    }

    @Override
    public IFileToolsEvent getEvent() {
        return this.event;
    }

    @Override
    public void setEvent(IFileToolsEvent event) {
        IFileToolsEvent oldEvent = this.event;
        this.event = event;
        this.propertyChangeSupport.firePropertyChange(PROP_EVENT, oldEvent, event);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

