/*
 * Decompiled with CFR 0.152.
 */
package filemanager.tools;

import filemanager.tools.ChangeableFilter;
import filemanager.tools.IFileSourceReaderAndWriter;
import java.io.File;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openide.util.NbBundle;

public class FileTools {
    public static String getExtension(String location) {
        if (location == null || "".equals(location)) {
            return null;
        }
        String[] split = location.split("\\.");
        return "." + split[split.length - 1];
    }

    public static String getFileName(String filePath) {
        if (filePath == null || "".equals(filePath)) {
            return null;
        }
        String[] split = filePath.split(Pattern.quote(System.getProperty("file.separator")));
        return split[split.length - 1];
    }

    public static String getLocationToRead(IFileSourceReaderAndWriter reader) {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new ChangeableFilter(reader));
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            return file.getAbsolutePath();
        }
        return null;
    }

    public static String chooseLocationToSave(IFileSourceReaderAndWriter reader) {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new ChangeableFilter(reader));
        int returnVal = fc.showSaveDialog(null);
        if (returnVal == 0) {
            String msg;
            int r;
            File file = fc.getSelectedFile();
            if (file.exists() && (r = JOptionPane.showConfirmDialog(null, msg = NbBundle.getMessage(FileTools.class, (String)"actions.override.confirm"), "Confirm", 0)) == 1) {
                return null;
            }
            if (!file.getName().toLowerCase().endsWith(reader.getExtension())) {
                return file.getPath() + reader.getExtension();
            }
            return file.getPath();
        }
        return null;
    }
}

